package cn.com.duiba.supplier.channel.service.api.dto.response.wx.favor;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2023/8/19 18:23
 */
@Data
public class WxFavorStocksDto implements Serializable {
    
    private static final long serialVersionUID = -1055224859361053211L;

    /**
     * 批次号			 
     * 说明：微信为每个代金券批次分配的唯一id。 
     * 必填，string(20)
     */
    private String stockId;

    /**
     * 创建批次的商户号		 
     * 说明：批次创建方商户号。 
     * 必填，string(20)
     */
    private String stockCreatorMchId;

    /**
     * 批次名称
     * 说明：批次名称
     * 必填，string(20)
     */
    private String stockName;

    /**
     * 批次状态				 
     * 说明：批次状态
     * 枚举值：
     * unactivated：未激活
     * audit：审核中
     * running：运行中
     * stoped：已停止
     * paused：暂停发放
     * 必填，string(12)
     */
    private String status;

    /**
     * 创建时间						 
     * 说明：批次创建时间，遵循rfc3339标准格式，格式为yyyy-MM-DDTHH:mm:ss+TIMEZONE，yyyy-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss表示时分秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC 8小时，即北京时间）。例如：2015-05-20T13:29:35+08:00表示，北京时间2015年5月20日 13点29分35秒。
     * 示例值：2015-05-20T13:29:35+08:00
     * 必填，string(32)
     */
    private String createTime;

    /**
     * 使用说明							 
     * 说明：批次描述信息
     * 示例值：微信支付营销
     * 必填，string(3000)
     */
    private String description;

    /**
     * 可用开始时间						 
     * 说明：可用开始时间，遵循rfc3339标准格式，格式为yyyy-MM-DDTHH:mm:ss+TIMEZONE，yyyy-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss表示时分秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC 8小时，即北京时间）。例如：2015-05-20T13:29:35+08:00表示，北京时间2015年5月20日 13点29分35秒。
     * 示例值：2015-05-20T13:29:35+08:00
     * 必填，string(32)
     */
    private String availableBeginTime;

    /**
     * 可用结束时间						 
     * 说明：可用结束时间，遵循rfc3339标准格式，格式为yyyy-MM-DDTHH:mm:ss+TIMEZONE，yyyy-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss表示时分秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC 8小时，即北京时间）。例如：2015-05-20T13:29:35+08:00表示，北京时间2015年5月20日 13点29分35秒。
     * 示例值：2015-05-20T13:29:35+08:00
     * 必填，string(32)
     */
    private String availableEndTime;

    /**
     * 已发券数量							 
     * 说明：已发券数量
     * 示例值：100
     * 必填，uint32
     */
    private Long distributedCoupons;

    /**
     * 是否无资金流							 
     * 说明：枚举值：true：是, false：否
     * 必填
     */
    private Boolean noCash;

    /**
     * 激活批次的时间								 
     * 说明：批次激活开启时间，遵循rfc3339标准格式，格式为yyyy-MM-DDTHH:mm:ss+TIMEZONE，yyyy-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss表示时分秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC 8小时，即北京时间）。例如：2015-05-20T13:29:35+08:00表示，北京时间2015年5月20日 13点29分35秒。
     * 示例值：2015-05-20T13:29:35+08:00
     * 非必填，string(32)
     */
    private String startTime;

    /**
     * 终止批次的时间									 
     * 说明：批次永久停止时间，遵循rfc3339标准格式，格式为yyyy-MM-DDTHH:mm:ss+TIMEZONE，yyyy-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss表示时分秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC 8小时，即北京时间）。例如：2015-05-20T13:29:35+08:00表示，北京时间2015年5月20日 13点29分35秒。
     * 示例值：2015-05-20T13:29:35+08:00
     * 非必填，string(32)
     */
    private String stopTime;

    /**
     * 是否单品优惠								 
     * 说明：枚举值：true：是, false：否
     * 必填
     */
    private Boolean singleItem;

    /**
     * 批次类型								 
     * 说明：批次类型， 枚举值：
     * NORMAL：代金券批次
     * DISCOUNT_CUT：立减与折扣
     * OTHER：其他
     * 示例值：NORMAL
     * 必填，string(16)
     */
    private String stockType;

    /**
     * 满减券信息
     * 说明：普通满减券面额、门槛信息。
     * 非必填
     */
    private WxFavorStockUseRuleDto stockUseRule;
}
