package cn.com.duiba.supplier.channel.service.api.enums.channel;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 晓见订单状态枚举
 *
 * @author wangguanhua
 */
@RequiredArgsConstructor
@Getter
public enum XiaoJianOrderStatusEnum {

    NOT_RECHARGED(1, "未充值"),
    RECHARGING(2, "充值中"),
    RECHARGE_SUCCESSFUL(3, "充值成功"),
    RECHARGE_FAILED(4, "充值失败"),
    ORDER_NOT_FOUND(5, "订单不存在");;

    private static final Map<Integer, XiaoJianOrderStatusEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(XiaoJianOrderStatusEnum::getCode, Function.identity(), (v1, v2) -> v2)));
    private final Integer code;
    private final String desc;

    /**
     * 根据枚举code获取枚举
     *
     * @param code 枚举code
     * @return 枚举
     */
    public static XiaoJianOrderStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }
}
