package cn.com.duiba.supplier.channel.service.api.enums.channel;

import lombok.Getter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author cxw
 * @date 2024/07/19
 */
@Getter
public enum XingXingCodeEnum {



    // 以下状态为进行中
    CODE_SUCCESS(200, "操作成功"),
    CODE_SERVER_INTERNAL_ERROR(500,"服务器内部错误"),
    USER_IS_EXIST(1000009,"用户已存在！"),
    CHECK_SIGN_IS_FAIL(1000010,"验签失败"),
    ORDER_IS_RECHARGE(1000011,"该笔订单已发起充值，请勿重复发起"),
    PRODUCT_IS_EXIST(1000012,"商品已存在！"),
    CUSTOMER_CHANNEL_IS_EXIST(1000014,"客户appid和渠道已存在！"),
    ORDER_IS_NULL(1000021,"订单不存在！"),
    ORDER_IS_FINISH(1000022,"该订单已充值完成！"),
    ORDER_STATUS_ERROR(1000023,"订单状态不正确！"),
    IP_NOT_ALLOWED(1000024, "请求IP不在白名单内"),
    RECHARGE_SUCCESS(1000025, "充值成功"),
    QUERY_RATE_FAST(1000027, "查询频繁,请间隔30秒后再次查询同一订单"),
    VOUCHER_CODE_INVALID(1000029, "券码无效"),
    VOUCHER_CODE_USE_FAILED(1000030, "券码使用失败"),
    RECHARGE_AMOUNT_LIMIT(1000031, "充值已达上限"),
    INSUFFICIENT_ACCOUNT_BALANCE(1000033, "账户余额不足"),
    CAN_NOT_CANCEL(1000035, "订单无法取消"),


    // 以下状态直接失败
    PARAM_FAIL(1000001,"请求参数有误"),
    CODE_USER_NOT_LOGIN(1000002, "未登录"),
    AUTH_TOKEN_ISNULL(1000003,"请重新登录"),
    USER_NAME_IS_NULL(1000004,"用户名不能为空！"),
    PASSWORD_IS_NULL(1000005,"密码不能为空！"),
    USERNAME_OR_PASSWORD_EEROR(1000007,"用户名或密码错误！"),
    USERNAME_STATUS_EEROR(1000008,"用户状态不正常！"),
    USER_IS_NULL(1000006,"用户不存在！"),
    PRODUCT_IS_NULL(1000013,"商品不存在！"),
    CUSTOMER_IS_NULL(1000015,"客户不存在！"),
    APPID_IS_NULL(1000016,"客户接入appId不能为空！"),
    PRODUCTID_IS_NULL(1000017,"商品不能为空！"),
    RECHARGE_ACCOUNT_IS_NULL(1000018,"充值账号不能为空！"),
    RECHARGE_ACCOUNT_TYPE_IS_NULL(1000019,"充值账号类型不能为空！"),
    RECHARGE_ERROR(1000020,"充值失败！"),
    GET_VALID_ACCESS_TOKEN(1000028, "获取accessToken失败"),
    NON_PRODUCT_CONFIG(1000032, "未查询到卡密产品配置"),
    PRODUCT_CONFIG_WRONG(1000034, "商品配置错误"),
    ;

    public static final List<Integer> ERROR_LIST = Arrays.asList(PARAM_FAIL.code, CODE_USER_NOT_LOGIN.code, AUTH_TOKEN_ISNULL.code, USER_NAME_IS_NULL.code, PASSWORD_IS_NULL.code,
            USERNAME_OR_PASSWORD_EEROR.code, USERNAME_STATUS_EEROR.code, USER_IS_NULL.code, PRODUCT_IS_NULL.code, CUSTOMER_IS_NULL.code, APPID_IS_NULL.code, PRODUCTID_IS_NULL.code, RECHARGE_ACCOUNT_IS_NULL.code,
            RECHARGE_ACCOUNT_TYPE_IS_NULL.code, RECHARGE_ERROR.code, GET_VALID_ACCESS_TOKEN.code, NON_PRODUCT_CONFIG.code, PRODUCT_CONFIG_WRONG.code)
            ;


    private final Integer code;
    private final String message;

    XingXingCodeEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }


}
