package cn.com.duiba.supplier.channel.service.api.enums.channel;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 发券状态 (1：成功；2：失败)
 *
 * @author wangguanhua
 */
@RequiredArgsConstructor
@Getter
public enum ZhonglianErrCodeEnum {

    STOCK_NOT_EXIST("批次不存在", "请检查请求参数中填写的代金券批次id和商户号是否正确"),
    BLOCKED_BY_SPAMCHK("小号拦截", "当前发放用户为小号，根据风险管控规则不允许给小号发放。"),
    DAY_BUDGET_NOT_ENOUGH("批次达到单天发放预算上限", "发券数量已经达到单天发放上限，可在商户平台批次详情页修改单天发放预算"),
    USER_AL_GET_COUPON("你已领取过该代金券", "用户已领过，正常逻辑报错"),
    NETWORK_ERROR("网络环境不佳，请重试", "请重试"),
    AL_STOCK_OVER("活动已结束", "活动已结束，属于正常逻辑错误"),
    FREQ_OVER_LIMIT("超过发放频率限制，请稍后再试", "请求对发放请求做频率控制"),
    PARAM_ERROR("校验参数错误（会返回具体哪个参数错误）", "根据错误提示确认参数无误并更正"),
    SIGN_ERROR("签名错误", "验证签名有误"),
    CA_ERROR("证书有误", "确认证书正确，或者联系商户平台更新证书"),
    REQ_PARAM_XML_ERR("输入参数xml格式有误", "检查入参的xml格式是否正确"),

    COUPON_STOCK_ID_EMPTY("批次ID为空", "确保批次id正确传入"),
    MCH_ID_EMPTY("商户ID为空", "确保商户id正确传入"),
    CODE_2_ID_ERR("商户id有误", "检查商户id是否正确并合法"),
    OPEN_ID_EMPTY("用户openid为空", "检查用户openid是否正确并合法"),

    ERR_VERIFY_SSL_SERIAL("获取客户端证书序列号失败!", "检查证书是否正确"),
    ERR_VERIFY_SSL_SN("获取客户端证书特征名称(DN)域失败!", "检查证书是否正确"),
    CA_VERIFY_FAILED("证书验证失败", "检查证书是否正确"),
    STOCK_IS_NOT_VALID("抱歉，该代金券已失效", "代金券已失效，请确认代金券的有效性，重新请求"),
    STOCK_AMOUNT_NOT_ENOUGH("代金券批次预算不足", "商户可为该代金券批次追加预算后继续发券"),
    MCH_NO_AUTH("商户无权限操作", "该商户无权限进行该操作，请前往商户平台开通代金券权限"),
    ACCOUNTERROR("帐号行为异常，无法领券", "请求的代金券批次已在商户平台开启风险拦截功能，命中的用户无法领券，如需给用户发券，可创建不开启拦截的批次重发，或联系微信支付客服。");;

    private static final Map<String, ZhonglianErrCodeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(Enum::name, Function.identity(), (v1, v2) -> v2)));
    private final String description;
    private final String solution;

    /**
     * 根据枚举名称获取枚举
     *
     * @param name 枚举名称
     * @return 枚举
     */
    public static ZhonglianErrCodeEnum getByName(String name) {
        if (name == null) {
            return null;
        }
        return ENUM_MAP.get(name);
    }
}
