package cn.com.duiba.supplier.channel.service.api.dto.request.alipay;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 支付宝账单下载请求参数
 * @author lfh
 */
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Data
public class AlipayDownLoadRequest implements Serializable {

    private static final long serialVersionUID = -4486099055580839537L;
    /**
     * 下载链接
     */
    private String downloadUrl;

    /**
     * 支付宝应用ID
     */
    private String alipayAppId;

    /**
     * 开始时间（用于确定存储路径）
     */
    private Date startTime;

}
