package cn.com.duiba.supplier.channel.service.api.enums.channel;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 荣数发货状态（直冲关注 3-充值成功 和 7-充值失败）
 *
 * @author wangguanhua
 */
@RequiredArgsConstructor
@Getter
public enum RongshuDeliveryStatusEnum {

    /**
     * 待发货
     */
    PENDING_SHIPMENT("0", "待发货"),

    /**
     * 退货审核中
     */
    RETURN_REVIEW("1", "退货审核中"),

    /**
     * 已取消
     */
    CANCELLED("2", "已取消"),

    /**
     * 已发货
     */
    SHIPPED("3", "已发货"),

    /**
     * 已退货
     */
    RETURNED("4", "已退货"),

    /**
     * 部分取消
     */
    PARTIALLY_CANCELLED("5", "部分取消"),

    /**
     * 部分退货
     */
    PARTIALLY_RETURNED("6", "部分退货"),

    /**
     * 发货失败
     */
    SHIPMENT_FAILED("7", "发货失败");

    private static final Map<String, RongshuDeliveryStatusEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(RongshuDeliveryStatusEnum::getStatus, Function.identity(), (v1, v2) -> v2)));
    private final String status;
    private final String description;

    /**
     * 根据枚举code获取枚举
     *
     * @param code 枚举code
     * @return 枚举
     */
    public static RongshuDeliveryStatusEnum getByStatus(String code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

}
