package cn.com.duiba.thirdpartyvnew.dto.wanda.request;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 万达优惠券反核销请求DTO
 *
 * @author zhangdaqing
 * @date 2025/7/10
 */
@Data
public class WandaCouponCancelRequest implements Serializable {
    
    private static final long serialVersionUID = 1L;
    
    /**
     * 优惠券码（必填）
     */
    private String couponNo;
    
    /**
     * 反核销地点（可选）
     */
    private String placeCode;
    
    /**
     * 反核销渠道（必填）
     */
    private String usedChannel;
    
    /**
     * 反核销酒店编码（可选）
     */
    private String usedStore;
    
    /**
     * 交易流水号（必填）
     */
    private String transactionNo;
    
    /**
     * 使用日期 yyyy-MM-dd（可选）
     */
    private String useDate;
    
    /**
     * 订单号（可选）
     */
    private String orderNo;
    
    /**
     * 订单金额（可选）
     */
    private BigDecimal orderAmount;
    
    /**
     * 折扣金额（可选）
     */
    private BigDecimal discountAmount;
    
    /**
     * 操作人（可选）
     */
    private String operateBy;
    
    /**
     * 创建优惠券反核销请求
     * 
     * @param couponNo 优惠券码
     * @param usedChannel 反核销渠道
     * @param transactionNo 交易流水号
     * @return WandaCouponCancelRequest
     */
    public static WandaCouponCancelRequest create(String couponNo, String usedChannel, String transactionNo) {
        WandaCouponCancelRequest request = new WandaCouponCancelRequest();
        request.setCouponNo(couponNo);
        request.setUsedChannel(usedChannel);
        request.setTransactionNo(transactionNo);
        return request;
    }
    
    /**
     * 验证必填字段
     */
    public void validate() {
        if (StringUtils.isBlank(couponNo)) {
            throw new IllegalArgumentException("优惠券码不能为空");
        }
        if (StringUtils.isBlank(transactionNo)) {
            throw new IllegalArgumentException("交易流水号不能为空");
        }
    }
} 