package cn.com.duiba.thirdpartyvnew.api.lzlj;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.thirdpartyvnew.dto.lzlj.base.LzljBaseRequest;
import cn.com.duiba.thirdpartyvnew.dto.lzlj.base.LzljBaseResponse;
import cn.com.duiba.thirdpartyvnew.dto.lzlj.request.CreateProductRequestData;
import cn.com.duiba.thirdpartyvnew.dto.lzlj.request.OrderDeliveryRequestData;
import cn.com.duiba.thirdpartyvnew.dto.lzlj.request.OrderReturnRequestData;
import cn.com.duiba.thirdpartyvnew.dto.lzlj.request.ProductEffectRequestData;
import cn.com.duiba.thirdpartyvnew.dto.lzlj.request.ProductUpdateRequestData;

@AdvancedFeignClient
public interface RemoteLzljPurchaseService {
    /**
     * 创建新产品。
     * 根据提供的产品信息，在系统中创建一个新的产品记录。
     *
     * @param request 包含产品详细信息的请求对象
     * @return 创建结果，指示操作是否成功
     */
    LzljBaseResponse<String> createProduct(LzljBaseRequest<CreateProductRequestData> request);

    /**
     * 修改现有产品信息。
     * 根据提供的产品编码和更新信息，修改系统中已存在的产品记录。
     *
     * @param request 包含产品更新信息的请求对象
     * @return 修改结果，指示操作是否成功
     */
    LzljBaseResponse<String> updateProduct(LzljBaseRequest<ProductUpdateRequestData> request);


    /**
     * 设置产品的生效或失效状态。
     * 根据产品编码和状态标志（生效/失效），更新产品的状态。
     *
     * @param request 生效请求
     * @return 设置结果，指示操作是否成功
     */
    LzljBaseResponse<String> setProductEffectiveness(LzljBaseRequest<ProductEffectRequestData> request);

    /**
     * 处理第三方订单的退货。
     * 根据提供的订单信息和取消原因，完成订单的退货操作。
     *
     * @param request 包含订单退货信息的请求对象
     * @return 退货结果，指示操作是否成功
     */
    LzljBaseResponse<String> returnOrder(LzljBaseRequest<OrderReturnRequestData> request);


    /**
     * 处理第三方订单的发货。
     * 根据提供的订单信息和物流信息，完成订单的发货操作。
     *
     * @param request 包含订单发货信息的请求对象
     * @return 发货结果，指示操作是否成功
     */
    LzljBaseResponse<String> deliverOrder(LzljBaseRequest<OrderDeliveryRequestData> request);
}
