package cn.com.duiba.thirdpartyvnew.dto.wanda.response;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 万达获取会员优惠券响应DTO
 *
 * @author zhangdaqing
 * @date 2025/7/10
 */
@Data
public class WandaCouponQueryResponse implements Serializable {
    
    private static final long serialVersionUID = 1L;
    
    /**
     * 状态码；200正常
     */
    private Integer status;
    
    /**
     * 响应消息
     */
    private String message;
    
    /**
     * 总数量
     */
    private Integer totalCount;
    
    /**
     * 优惠券明细列表
     */
    private List<WandaCouponDetail> data;
    
    /**
     * 判断是否成功
     * 
     * @return true: 成功, false: 失败
     */
    public boolean isSuccess() {
        return status != null && status == 200;
    }
    
    /**
     * 判断是否有数据
     * 
     * @return true: 有数据, false: 无数据
     */
    public boolean hasData() {
        return data != null && !data.isEmpty();
    }
    
    /**
     * 获取实际返回的券数量
     * 
     * @return 券数量
     */
    public int getActualCount() {
        return data != null ? data.size() : 0;
    }
    
    /**
     * 获取可用的优惠券数量
     * 
     * @return 可用券数量
     */
    public long getAvailableCount() {
        if (data == null) {
            return 0;
        }
        return data.stream().filter(WandaCouponDetail::isAvailable).count();
    }
    
    /**
     * 获取已使用的优惠券数量
     * 
     * @return 已使用券数量
     */
    public long getUsedCount() {
        if (data == null) {
            return 0;
        }
        return data.stream().filter(WandaCouponDetail::isUsed).count();
    }
    
    /**
     * 获取已过期的优惠券数量
     * 
     * @return 已过期券数量
     */
    public long getExpiredCount() {
        if (data == null) {
            return 0;
        }
        return data.stream().filter(WandaCouponDetail::isExpired).count();
    }
} 