package cn.com.duiba.thirdpartyvnew.dto.jincheng;

import cn.com.duiba.thirdpartyvnew.dto.jincheng.top.BaseReqDto;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.top.BaseReqInterface;

import java.io.Serializable;

/**
 * 金城银行-用户积分调整-请求入参
 */
public class HdOrderApplyReqDto implements BaseReqInterface, Serializable {

    /**
     * 调整类型(add：加分,deduct：减分)
     */
    private String adjustType;

    /**
     * 调整的积分值
     */
    private String scoreValue;

    /**
     * 请求订单号
     */
    private String orderNo;

    /**
     * 备注【建议调整积分原因】
     */
    private String remark;

    /**
     * 基本值入参
     */
    private BaseReqDto commonParam;

    @Override
    public BaseReqDto getCommonParam() {
        return commonParam;
    }

    public void setCommonParam(BaseReqDto commonParam) {
        this.commonParam = commonParam;
    }

    public String getAdjustType() {
        return adjustType;
    }

    public void setAdjustType(String adjustType) {
        this.adjustType = adjustType;
    }

    public String getScoreValue() {
        return scoreValue;
    }

    public void setScoreValue(String scoreValue) {
        this.scoreValue = scoreValue;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
