package cn.com.duiba.thirdpartyvnew.dto.wanda.request;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 万达优惠券核销请求DTO
 *
 * @author zhangdaqing
 * @date 2025/7/10
 */
@Data
public class WandaCouponVerificationRequest implements Serializable {
    
    private static final long serialVersionUID = 1L;
    
    /**
     * 优惠券码（必填）
     */
    private String couponNo;
    
    /**
     * 核销地点（可选）
     */
    private String placeCode;
    
    /**
     * 使用渠道（必填）
     */
    private String usedChannel;
    
    /**
     * 使用酒店编码（可选）
     */
    private String usedStore;
    
    /**
     * 使用品牌（可选）
     */
    private String usedBrand;
    
    /**
     * 手机号（必填）
     */
    private String mobile;
    
    /**
     * 交易流水号（必填）
     */
    private String transactionNo;
    
    /**
     * 消费金额（可选）
     */
    private String amount;
    
    /**
     * 使用分类（可选）
     */
    private String categoryCode;
    
    /**
     * 会员等级代码（可选）
     */
    private String memberLevelCode;
    
    /**
     * 使用日期 yyyy-MM-dd（可选）
     */
    private String useDate;
    
    /**
     * 订单号（可选）
     */
    private String orderNo;
    
    /**
     * 订单金额（可选）
     */
    private BigDecimal orderAmount;
    
    /**
     * 创建优惠券核销请求
     * 
     * @param couponNo 优惠券码
     * @param usedChannel 使用渠道
     * @param mobile 手机号
     * @param transactionNo 交易流水号
     * @return WandaCouponVerificationRequest
     */
    public static WandaCouponVerificationRequest create(String couponNo, String usedChannel, 
                                                        String mobile, String transactionNo) {
        WandaCouponVerificationRequest request = new WandaCouponVerificationRequest();
        request.setCouponNo(couponNo);
        request.setUsedChannel(usedChannel);
        request.setMobile(mobile);
        request.setTransactionNo(transactionNo);
        return request;
    }
    
    /**
     * 验证必填字段
     */
    public void validate() {
        if (StringUtils.isBlank(couponNo)) {
            throw new IllegalArgumentException("优惠券码不能为空");
        }
        /*if (StringUtils.isBlank(usedChannel)) {
            throw new IllegalArgumentException("使用渠道不能为空");
        }*/
      /*  if (StringUtils.isBlank(mobile)) {
            throw new IllegalArgumentException("手机号不能为空");
        }*/
        if (StringUtils.isBlank(transactionNo)) {
            throw new IllegalArgumentException("交易流水号不能为空");
        }
    }
} 