package cn.com.duiba.thirdparty.api;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 报警服务接口
 */
@AdvancedFeignClient
public interface RemoteAlarmService {

    /**
     * 发送邮件
     * @param mail
     * @param
     * @return
     */
	public DubboResult<Boolean> sendMail(String[] mail, String title, String content, boolean isHtml);

    /**
     * 发送短信
     * @param phone
     * @param text
     * @return
     */
    public DubboResult<String> sendMessage(String phone, String text);

    /**
     * 发送到叮叮机器人
     * @param robootKey
     * @param text
     * @return
     */
    public DubboResult<String> sendDingding(String robootKey, String text);

}
