package cn.com.duiba.thirdparty.api;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * 扣积分接口服务
 *
 */
@AdvancedFeignClient
public interface RemoteCreditsService {

	/**
	 * @deprecated
	 * 扣积分接口<br/>
	 * 1.将扣积分请求丢到HTTP请求池中<br/>
	 * 2.返回Boolean是否提交成功<br/>
	 * 3.HTTP异步处理完后会把响应结果发送到 callbackTopic队列中<br/>
	 * 4.业务放订阅callbackTopic队列进行后续流程<br/>
	 * 
	 * @param request 扣积分请求参数
	 * @param callbackTopic 扣积分回调topic
	 * @return boolean ture:提交成功   false:提交失败
	 */
	@Deprecated
	@RequestMapping("deprecatedSubmitSubCredits")
	public DubboResult<Boolean> submitSubCredits(CreditsMessage request, String callbackTopic);
	
	/**
	 * @deprecated
	 * 加积分接口<br/>
	 * 1.将扣积分请求丢到HTTP请求池中<br/>
	 * 2.返回Boolean是否提交成功<br/>
	 * 3.HTTP异步处理完后会把响应结果发送到 callbackTopic队列中<br/>
	 * 4.业务放订阅callbackTopic队列进行后续流程<br/>
	 * 
	 * @param request 扣积分请求参数
	 * @param callbackTopic 扣积分回调topic
	 * @return boolean ture:提交成功   false:提交失败
	 */
	@Deprecated
	@RequestMapping("deprecatedSubmitAddCredits")
	public DubboResult<Boolean> submitAddCredits(CreditsMessage request, String callbackTopic);
	
	/**
	 * 扣积分接口<br/>
	 * 1.将扣积分请求丢到HTTP请求池中<br/>
	 * 2.返回Boolean是否提交成功<br/>
	 * 3.HTTP异步处理完后会把响应结果发送到 ONS队列中<br/>
	 * 4.业务放订阅callbackTopic队列进行后续流程<br/>
	 * 
	 * @param request 扣积分请求参数
	 * @param callbackTopic 扣积分回调topic
	 * @param tag 消息标签
	 * @param key 非必填项
	 * @return boolean ture:提交成功   false:提交失败
	 */
	public DubboResult<Boolean> submitSubCredits(CreditsMessage request, String callbackTopic, String tag, String key);
	
	/**
	 * 加积分接口<br/>
	 * 1.将扣积分请求丢到HTTP请求池中<br/>
	 * 2.返回Boolean是否提交成功<br/>
	 * 3.HTTP异步处理完后会把响应结果发送到 callbackTopic队列中<br/>
	 * 4.业务放订阅callbackTopic队列进行后续流程<br/>
	 * 
	 * @param request 加积分请求参数
	 * @param callbackTopic 扣积分回调topic
	 * @param tag 消息标签
	 * @param key 非必填项
	 * @return boolean ture:提交成功   false:提交失败
	 */
	public DubboResult<Boolean> submitAddCredits(CreditsMessage request, String callbackTopic, String tag, String key);

}
