package cn.com.duiba.thirdparty.dto;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * 虚拟卡扣除消息
 * Created by xiaoxuda on 2017/8/30.
 */
public class VirtualCardMessage implements Serializable{
    private static final long serialVersionUID = 7301300077072580063L;

    /**调用方式**/
    public static final String HTTP_GET = "get";
    public static final String HTTP_POST = "post";

    /** 补签卡 */
    public static final String TYPE_RESIGN = "reSignCard";

    /**
     * 业务ID
     */
    private String relationId;
    /**
     * 业务类型
     */
    private String relationType;
    /**
     * appId
     */
    private String appId;
    /**
     * 兑吧系统用户ID
     */
    private String consumerId;
    /**
     * http请求方式，目前支持get、set
     */
    private String httpType;
    /**
     * 请求链接
     */
    private String httpUrl;
    /**
     * 需要发送给开发者服务器，包含鉴权需要的字段，业务字段
     */
    private Map<String, String> authParams;
    /**
     * 用与消息透传，第三方服务不做处理，直接通过消息返回给消息消费者
     */
    private Map<String, String> params;

    public String getRelationId() {
        return relationId;
    }

    public void setRelationId(String relationId) {
        this.relationId = relationId;
    }

    public String getRelationType() {
        return relationType;
    }

    public void setRelationType(String relationType) {
        this.relationType = relationType;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(String consumerId) {
        this.consumerId = consumerId;
    }

    public String getHttpType() {
        return httpType;
    }

    public void setHttpType(String httpType) {
        this.httpType = httpType;
    }

    public String getHttpUrl() {
        return httpUrl;
    }

    public void setHttpUrl(String httpUrl) {
        this.httpUrl = httpUrl;
    }

    public Map<String, String> getAuthParams() {
        return authParams;
    }

    public void setAuthParams(Map<String, String> authParams) {
        this.authParams = authParams;
    }

    public String getFromAuthParmas(String key){
        if(this.authParams == null){
            return null;
        }
        return this.authParams.get(key);
    }

    public void put2AuthParams(String key, String value){
        if(this.authParams == null){
            this.authParams = new HashMap<>();
        }
        this.authParams.put(key, value);
    }

    public Map<String, String> getParams() {
        return params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public String getFromParmas(String key){
        if(this.params == null){
            return null;
        }
        return this.params.get(key);
    }

    public void put2Params(String key, String value){
        if(this.params == null){
            this.params = new HashMap<>();
        }
        this.params.put(key, value);
    }
}
