package cn.com.duiba.thirdparty.dto;

import java.io.Serializable;
import java.util.Map;

/**
 * HTTP响应消息
 */
public class HttpResponseMessageDto implements Serializable {

	private static final long serialVersionUID = 7657441142341850560L;

	public static final String CALLBACK_TYPE_FAILED = "failed";
	public static final String CALLBACK_TYPE_CANCELLED = "cancelled";
	public static final String CALLBACK_TYPE_COMPLETED = "completed";

	private String bizType; // 业务类型
	private String bizId; // 业务唯一编号
	private String callbackType; // 响应类型
	private String httpUrl; // 请求URL
	private Map<String, String> httpParams; // 请求参数
	private Map<String, String> extendParams; // 扩展参数
	private String body; // 响应内容
	private String errorMessage; // 错误信息
	private Boolean success; // 是否处理成功
	private Long timestamp = System.currentTimeMillis(); // 时间搓

	public String getBizType() {
		return bizType;
	}

	public void setBizType(String bizType) {
		this.bizType = bizType;
	}

	public String getBizId() {
		return bizId;
	}

	public void setBizId(String bizId) {
		this.bizId = bizId;
	}

	public String getCallbackType() {
		return callbackType;
	}

	public void setCallbackType(String callbackType) {
		this.callbackType = callbackType;
	}

	public String getHttpUrl() {
		return httpUrl;
	}

	public void setHttpUrl(String httpUrl) {
		this.httpUrl = httpUrl;
	}

	public Map<String, String> getHttpParams() {
		return httpParams;
	}

	public void setHttpParams(Map<String, String> httpParams) {
		this.httpParams = httpParams;
	}

	public Map<String, String> getExtendParams() {
		return extendParams;
	}

	public void setExtendParams(Map<String, String> extendParams) {
		this.extendParams = extendParams;
	}

	public String getBody() {
		return body;
	}

	public void setBody(String body) {
		this.body = body;
	}

	public String getErrorMessage() {
		return errorMessage;
	}

	public void setErrorMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}

	public Boolean getSuccess() {
		return success;
	}

	public void setSuccess(Boolean success) {
		this.success = success;
	}

	public Long getTimestamp() {
		return timestamp;
	}

	public void setTimestamp(Long timestamp) {
		this.timestamp = timestamp;
	}

}
