package cn.com.duiba.thirdparty.api;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 报警服务接口
 */
@AdvancedFeignClient
public interface RemoteAlarmService {

    /**
     * 发送邮件
     * @param mail
     * @param
     * @return
     */
	public DubboResult<Boolean> sendMail(String[] mail, String title, String content, boolean isHtml);

    /**
     * 发送短信
     * @param phone
     * @param text
     * @return
     */
    public DubboResult<String> sendMessage(String phone, String text);

    /**
     * 发送到叮叮机器人
     * @param robootKey
     * @param text
     * @return
     */
    public DubboResult<String> sendDingding(String robootKey, String text);


    /**
     * 根据邮箱发送钉钉个人通知
     * @param emails 接收个人通知的邮箱，通过邮箱去sso获取钉钉用户id信息
     * @param content 发送的消息内容
     * @return
     */
    Boolean sendPersonalDingTextMsgByEmail(List<String> emails, String content);

    /**
     * 根据钉钉用户id发送个人文本通知消息，dingId可以从sso的adminDto中获取
     * @param dingUserIds 接收消息的钉钉用户id列表
     * @param content 发送的文本消息
     * @return
     */
    Boolean sendPersonalDingTextMsgByDingId(List<String> dingUserIds, String content);


}
