package cn.com.duiba.thirdparty.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 扣积分接口，兑换类型，详见：http://docs.duiba.com.cn/tech_doc_book/server/consume_credits_api.html 参数介绍
 * Created by xiaoxuda on 2018/2/11.
 */
public enum CreditsConsumeTypeEnum {
    MILLIONAIRE(1, "millionaire", "冲顶大会"),
    ALIPAY(2, "alipay", "支付宝"),
    QB(3, "qb", "Q币"),
    COUPON(4, "coupon", "优惠券"),
    OBJECT(5, "object", "实物"),
    PHONE_BILL(6, "phonebill", "话费"),
    PHONE_FLOW(7, "phoneflow", "流量"),
    VIRTUAL(8, "virtual", "虚拟商品"),
    LITTLE_GAME(9, "littleGame", "小游戏"),
    SINGLE_LOTTERY(10, "singleLottery", "单品抽奖"),
    HDTOOL_LOTTERY(11, "hdtoolLottery", "活动抽奖"),
    HDTOOL(12, "htool", "活动工具"),
    MANUAL_LOTTERY(13, "manualLottery", "手动开奖"),
    NGAME(14, "ngameLottery", "新游戏"),
    QUESSION(15, "questionLottery", "答题"),
    QUIZZ(16, "quizzLottery", "测试题"),
    GUESS(17, "guessLottery", "竞猜"),
    RESIGN(18, "reSignConsume", "签到补签"),
    PLUGIN(19, "plugin", "插件活动"),
    SIGN_CONTRACT_BET(20, "signContractBet", "签到契约参与扣积分");

    private static Map<Integer, CreditsConsumeTypeEnum> typeMap = new HashMap<>();
    static{
        for(CreditsConsumeTypeEnum type : values()){
            typeMap.put(type.getCode(), type);
        }
    }

    public static CreditsConsumeTypeEnum getByCode(Integer code){
        return typeMap.get(code);
    }

    private Integer code;
    private String type;
    private String desc;

    CreditsConsumeTypeEnum(Integer code, String type, String desc){
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

}
