package cn.com.duiba.thirdparty.mq.msg;

import cn.com.duiba.thirdparty.enums.HttpRequestResultType;
import cn.com.duiba.thirdparty.enums.SubCreditsServiceType;
import com.alibaba.fastjson.JSONObject;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Map;

/**
 * 扣积分响应mq消息
 */
public class SubCreditsResultMsg implements Serializable {

    /**
     * http消息请求完成:扣积分成功
     */
    public static final int CODE_SUCCESS = 1;
    /**
     * http消息请求完成:扣积分消息解析失败
     */
    public static final int CODE_PARSE_JSON_FAIL = 2;
    /**
     * http消息请求完成:积分不够
     */
    public static final int CODE_NORMAL_FAIL = 3;

    private static final long serialVersionUID = 1025203922881796932L;

    /**
     * 回调类型
     */
    private HttpRequestResultType resultType; // failed,completed,cancelled
    /**
     * 扣积分是否成功标志，ture表示成功，false失败
     */
    private int code;
    /**
     * 开发者id，扣积分成功后必选
     */
    private String bizId;

    /**
     * 扣积分成功后必选
     */
    private Long credits;

    /**
     * 开发者返回的扣积分失败文案
     */
    private String errorMessage;

    /**
     * 开发者响应消息，仅扣积分json解析失败时存在
     */
    private String response;

    private Long appId;
    private Long consumerId;
    private String relationId;
    private SubCreditsServiceType relationType;
    private String httpUrl;
    private Map<String, String> params;

    public String getRelationId() {
        return relationId;
    }

    public void setRelationId(String relationId) {
        this.relationId = relationId;
    }

    public SubCreditsServiceType getRelationType() {
        return relationType;
    }

    public void setRelationType(SubCreditsServiceType relationType) {
        this.relationType = relationType;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public HttpRequestResultType getResultType() {
        return resultType;
    }

    public void setResultType(HttpRequestResultType resultType) {
        this.resultType = resultType;
    }

    public Map<String, String> getParams() {
        return params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public String getHttpUrl() {
        return httpUrl;
    }

    public void setHttpUrl(String httpUrl) {
        this.httpUrl = httpUrl;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public Long getCredits() {
        return credits;
    }

    public void setCredits(Long credits) {
        this.credits = credits;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getResponse() {
        return response;
    }

    public void setResponse(String response) {
        this.response = response;
    }


    /**
     * 解码消息，接收mq消息使用
     *
     * @param msg
     * @return
     */
    public static SubCreditsResultMsg decode(byte[] msg) {
        String string = new String(msg, Charset.forName("utf-8"));
        if (string == null || string.isEmpty()) {
            return null;
        }
        return JSONObject.parseObject(string, SubCreditsResultMsg.class);
    }

    /**
     * 编码消息，发送时使用
     *
     * @param subCreditsResultMsg
     * @return
     */
    public static byte[] encode(SubCreditsResultMsg subCreditsResultMsg) {
        String string = JSONObject.toJSONString(subCreditsResultMsg);
        return string.getBytes(Charset.forName("utf-8"));
    }
}
