package cn.com.duiba.thirdparty.enums.virtual;

public enum VirtualItemChannelEnum {

    FULU("fulu", "福禄"),
    HUAZHU("huazhu", "华住"),
    BILIBILI("bilibili", "哔哩哔哩"),
    SUCCESS("success","成功"),
    FAIL("fail","失败"),
    TIME_OUT("timeout","超时"),
    ;

    private String code;
    private String desc;

    VirtualItemChannelEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static VirtualItemChannelEnum getByCode(String code) {
        for (VirtualItemChannelEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

}
