package cn.com.duiba.thirdparty.enums.funheadlines;

import java.util.Objects;

/**
 * @Description: 趣头条-接口错误码
 * @Author: fxr
 * @Date: 2019/4/3
 */
public enum FunHeadlinesErrorCode {

    SUCCESS("0", "响应成功"),

    // 开发者约定异常
    E10001("10001", "用户不存在"),
    E10002("10002", "ticket已失效"),
    E10003("10003", "appid不存在"),
    E10004("10004", "openid已失效"),
    E10005("10005", "platform不支持"),
    E10006("10006", "sign错误"),
    E10009("10009", "金币操作异常"),

    // 自定义异常
    E20001("20001", "开发者响应格式异常"),
    E20002("20002", "开发者响应内容解析异常"),
    E20003("20003", "未知异常,需跟开发者确认"),

    // 兑吧侧系统异常
    E20004("20004", "APP信息获取失败"),
    E20005("20005", "配置异常");

    private String code;
    private String desc;

    FunHeadlinesErrorCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static FunHeadlinesErrorCode valueOfCode(String code) {
        for (FunHeadlinesErrorCode obj : FunHeadlinesErrorCode.values()) {
            if (Objects.equals(obj.code, code)) {
                return obj;
            }
        }
        return E20003;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
