package cn.com.duiba.thirdparty.dto.wdt;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.gson.annotations.SerializedName;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

public class OrderInfoDto implements Serializable {
    private static final long serialVersionUID = -4998897917067441985L;

    // 1无库存记录 2地址发生变化 4发票变化 8仓库变化16备注变化32平台更换货品64退款...512抢单异常
    public static final int BAD_REASON_ADDRESS_CHANGE = 2;
    public static final int BAD_REASON_INVOICE_CHANGE = 4;
    public static final int BAD_REASON_WAREHOUSE_CHANGE = 8;
    public static final int BAD_REASON_REMARK_CHANGE = 16; // 客服备注
    public static final int BAD_REASON_GOODS_CHANGE = 32;
    // public static final int BAD_REASON_REFUND = 64;
    // //申请退款,订单审核时通过refund_status判断
    public static final int BAD_REASON_BLOCK_GIFT = 128;
    public static final int BAD_REASON_BLOCK_SWAP = 256; // 拦截换货
    // (1.换货订单因再次申请退款而拦截
    // 2.平台换货单取消/换改退)
    public static final int BAD_REASON_BUYER_MESSAGE_CHANGE = 512; // 客户备注发生变化
    public static final int BAD_REASON_BLOCK_SYNC_LOGISTICS = 1024; // 拦截平台已发货。

    @JSONField(name = "logistics_name")
    private String logisticsName;

    @JSONField(name = "warehouse_type")
    private Byte warehouseType;

    @JSONField(name = "fenxiao_nick")
    private String fenxiaoNick;

    @JSONField(name = "post_amount")
    private BigDecimal postAmount;

    @JSONField(name = "receiver_ring")
    private String receiverRing;

    @JSONField(name = "raw_goods_type_count")
    private BigDecimal rawGoodsTypeCount;

    @JSONField(name = "remark_flag")
    private Byte remarkFlag;

    @JSONField(name = "receiver_dtb")
    private String receiverDtb;

    @JSONField(name = "bad_reason")
    private Integer badReason;

    @JSONField(name = "print_remark")
    private String printRemark;

    @JSONField(name = "discount")
    private BigDecimal discount;

    @JSONField(name = "other_amount")
    private BigDecimal otherAmount;

    @JSONField(name = "pay_account")
    private String payAccount;

    @JSONField(name = "tax_rate")
    private BigDecimal taxRate;

    @JSONField(name = "raw_goods_count")
    private BigDecimal rawGoodsCount;

    @JSONField(name = "to_deliver_time")
    private String toDeliverTime;

    @JSONField(name = "fchecker_name")
    private String fcheckerName;

    @JSONField(name = "shop_remark")
    private String shopRemark;

    @JSONField(name = "invoice_id")
    private Integer invoiceId;

    @JSONField(name = "modified")
    private String modified;

    @JSONField(name = "shop_no")
    private String shopNo;

    @JSONField(name = "checker_name")
    private String checkerName;

    @JSONField(name = "receiver_area")
    private String receiverArea;

    @JSONField(name = "customer_no")
    private String customerNo;

    @JSONField(name = "refund_status")
    private Byte refundStatus;

    @JSONField(name = "receiver_province")
    private String receiverProvince;

    @JSONField(name = "buyer_message")
    private String buyerMessage;

    @JSONField(name = "created")
    private String created;

    @JSONField(name = "weight")
    private BigDecimal weight;

    @JSONField(name = "tax")
    private BigDecimal tax;

    @JSONField(name = "logistics_code")
    private String logisticsCode;

    @JSONField(name = "shop_name")
    private String shopName;

    @JSONField(name = "pay_time")
    private String payTime;

    @JSONField(name = "src_tids")
    private String srcTids;

    @JSONField(name = "checkouter_name")
    private String checkouterName;

    @JSONField(name = "trade_no")
    private String tradeNo;

    @JSONField(name = "id_card_type")
    private Byte idCardType;

    @JSONField(name = "freeze_reason")
    private String freezeReason;

    @JSONField(name = "single_spec_no")
    private String singleSpecNo;

    @JSONField(name = "salesman_name")
    private String salesmanName;

    @JSONField(name = "receiver_city")
    private String receiverCity;

    @JSONField(name = "invoice_title")
    private String invoiceTitle;

    @JSONField(name = "goods_type_count")
    private BigDecimal goodsTypeCount;

    @JSONField(name = "goods_count")
    private BigDecimal goodsCount;

    @JSONField(name = "cod_amount")
    private BigDecimal codAmount;

    @JSONField(name = "flag_name")
    private String flagName;

    @JSONField(name = "receiver_telno")
    private String receiverTelno;

    @JSONField(name = "receiver_zip")
    private String receiverZip;

    @JSONField(name = "warehouse_no")
    private String warehouseNo;

    @JSONField(name = "invoice_content")
    private String invoiceContent;

    @JSONField(name = "trade_status")
    private Byte tradeStatus;

    @JSONField(name = "post_cost")
    private BigDecimal postCost;

    @JSONField(name = "receiver_name")
    private String receiverName;

    @JSONField(name = "commission")
    private BigDecimal commission;

    @JSONField(name = "invoice_type")
    private Byte invoiceType;

    @JSONField(name = "currency")
    private String currency;

    @JSONField(name = "profit")
    private BigDecimal profit;

    @JSONField(name = "trade_from")
    private Byte tradeFrom;

    @JSONField(name = "delivery_term")
    private Byte deliveryTerm;

    @JSONField(name = "logistics_no")
    private String logisticsNo;

    @JSONField(name = "goods_amount")
    private BigDecimal goodsAmount;

    @JSONField(name = "goods_cost")
    private BigDecimal goodsCost;

    @JSONField(name = "receiver_district")
    private String receiverDistrict;

    @JSONField(name = "stockout_no")
    private String stockoutNo;

    @JSONField(name = "receivable")
    private BigDecimal receivable;

    @JSONField(name = "version_id")
    private Integer versionId;

    @JSONField(name = "receiver_mobile")
    private String receiverMobile;

    @JSONField(name = "buyer_nick")
    private String buyerNick;

    @JSONField(name = "fenxiao_type")
    private Byte fenxiaoType;

    @JSONField(name = "cs_remark")
    private String csRemark;

    @JSONField(name = "platform_id")
    private Byte platformId;

    @JSONField(name = "trade_type")
    private Byte tradeType;

    @JSONField(name = "receiver_address")
    private String receiverAddress;

    @JSONField(name = "logistics_type_name")
    private String logisticsTypeName;

    @JSONField(name = "ext_cod_fee")
    private BigDecimal extCodFee;

    @JSONField(name = "customer_name")
    private String customerName;

    @JSONField(name = "trade_time")
    private String tradeTime;

    @JSONField(name = "detail_list")
    private List<DetailInfoDto> detailList;

    public List<DetailInfoDto> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<DetailInfoDto> detailList) {
        this.detailList = detailList;
    }

    public String getLogisticsName()
    {
        return logisticsName;
    }

    public void setLogisticsName(String logisticsName)
    {
        this.logisticsName = logisticsName;
    }

    public Byte getWarehouseType()
    {
        return warehouseType;
    }

    public void setWarehouseType(Byte warehouseType)
    {
        this.warehouseType = warehouseType;
    }

    public String getFenxiaoNick()
    {
        return fenxiaoNick;
    }

    public void setFenxiaoNick(String fenxiaoNick)
    {
        this.fenxiaoNick = fenxiaoNick;
    }

    public BigDecimal getPostAmount()
    {
        return postAmount;
    }

    public void setPostAmount(BigDecimal postAmount)
    {
        this.postAmount = postAmount;
    }

    public String getReceiverRing()
    {
        return receiverRing;
    }

    public void setReceiverRing(String receiverRing)
    {
        this.receiverRing = receiverRing;
    }

    public BigDecimal getRawGoodsTypeCount()
    {
        return rawGoodsTypeCount;
    }

    public void setRawGoodsTypeCount(BigDecimal rawGoodsTypeCount)
    {
        this.rawGoodsTypeCount = rawGoodsTypeCount;
    }

    public Byte getRemarkFlag()
    {
        return remarkFlag;
    }

    public void setRemarkFlag(Byte remarkFlag)
    {
        this.remarkFlag = remarkFlag;
    }

    public String getReceiverDtb()
    {
        return receiverDtb;
    }

    public void setReceiverDtb(String receiverDtb)
    {
        this.receiverDtb = receiverDtb;
    }

    public Integer getBadReason()
    {
        return badReason;
    }

    public void setBadReason(Integer badReason)
    {
        this.badReason = badReason;
    }

    public String getPrintRemark()
    {
        return printRemark;
    }

    public void setPrintRemark(String printRemark)
    {
        this.printRemark = printRemark;
    }

    public BigDecimal getDiscount()
    {
        return discount;
    }

    public void setDiscount(BigDecimal discount)
    {
        this.discount = discount;
    }

    public BigDecimal getOtherAmount()
    {
        return otherAmount;
    }

    public void setOtherAmount(BigDecimal otherAmount)
    {
        this.otherAmount = otherAmount;
    }

    public String getPayAccount()
    {
        return payAccount;
    }

    public void setPayAccount(String payAccount)
    {
        this.payAccount = payAccount;
    }

    public BigDecimal getTaxRate()
    {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate)
    {
        this.taxRate = taxRate;
    }

    public BigDecimal getRawGoodsCount()
    {
        return rawGoodsCount;
    }

    public void setRawGoodsCount(BigDecimal rawGoodsCount)
    {
        this.rawGoodsCount = rawGoodsCount;
    }

    public String getToDeliverTime()
    {
        return toDeliverTime;
    }

    public void setToDeliverTime(String toDeliverTime)
    {
        this.toDeliverTime = toDeliverTime;
    }

    public String getFcheckerName()
    {
        return fcheckerName;
    }

    public void setFcheckerName(String fcheckerName)
    {
        this.fcheckerName = fcheckerName;
    }

    public String getShopRemark()
    {
        return shopRemark;
    }

    public void setShopRemark(String shopRemark)
    {
        this.shopRemark = shopRemark;
    }

    public Integer getInvoiceId()
    {
        return invoiceId;
    }

    public void setInvoiceId(Integer invoiceId)
    {
        this.invoiceId = invoiceId;
    }

    public String getModified()
    {
        return modified;
    }

    public void setModified(String modified)
    {
        this.modified = modified;
    }

    public String getShopNo()
    {
        return shopNo;
    }

    public void setShopNo(String shopNo)
    {
        this.shopNo = shopNo;
    }

    public String getCheckerName()
    {
        return checkerName;
    }

    public void setCheckerName(String checkerName)
    {
        this.checkerName = checkerName;
    }

    public String getReceiverArea()
    {
        return receiverArea;
    }

    public void setReceiverArea(String receiverArea)
    {
        this.receiverArea = receiverArea;
    }

    public String getCustomerNo()
    {
        return customerNo;
    }

    public void setCustomerNo(String customerNo)
    {
        this.customerNo = customerNo;
    }

    public Byte getRefundStatus()
    {
        return refundStatus;
    }

    public void setRefundStatus(Byte refundStatus)
    {
        this.refundStatus = refundStatus;
    }

    public String getReceiverProvince()
    {
        return receiverProvince;
    }

    public void setReceiverProvince(String receiverProvince)
    {
        this.receiverProvince = receiverProvince;
    }

    public String getBuyerMessage()
    {
        return buyerMessage;
    }

    public void setBuyerMessage(String buyerMessage)
    {
        this.buyerMessage = buyerMessage;
    }

    public String getCreated()
    {
        return created;
    }

    public void setCreated(String created)
    {
        this.created = created;
    }

    public BigDecimal getWeight()
    {
        return weight;
    }

    public void setWeight(BigDecimal weight)
    {
        this.weight = weight;
    }

    public BigDecimal getTax()
    {
        return tax;
    }

    public void setTax(BigDecimal tax)
    {
        this.tax = tax;
    }

    public String getLogisticsCode()
    {
        return logisticsCode;
    }

    public void setLogisticsCode(String logisticsCode)
    {
        this.logisticsCode = logisticsCode;
    }

    public String getShopName()
    {
        return shopName;
    }

    public void setShopName(String shopName)
    {
        this.shopName = shopName;
    }

    public String getPayTime()
    {
        return payTime;
    }

    public void setPayTime(String payTime)
    {
        this.payTime = payTime;
    }

    public String getSrcTids()
    {
        return srcTids;
    }

    public void setSrcTids(String srcTids)
    {
        this.srcTids = srcTids;
    }

    public String getCheckouterName()
    {
        return checkouterName;
    }

    public void setCheckouterName(String checkouterName)
    {
        this.checkouterName = checkouterName;
    }

    public String getTradeNo()
    {
        return tradeNo;
    }

    public void setTradeNo(String tradeNo)
    {
        this.tradeNo = tradeNo;
    }

    public Byte getIdCardType()
    {
        return idCardType;
    }

    public void setIdCardType(Byte idCardType)
    {
        this.idCardType = idCardType;
    }

    public String getFreezeReason()
    {
        return freezeReason;
    }

    public void setFreezeReason(String freezeReason)
    {
        this.freezeReason = freezeReason;
    }

    public String getSingleSpecNo()
    {
        return singleSpecNo;
    }

    public void setSingleSpecNo(String singleSpecNo)
    {
        this.singleSpecNo = singleSpecNo;
    }

    public String getSalesmanName()
    {
        return salesmanName;
    }

    public void setSalesmanName(String salesmanName)
    {
        this.salesmanName = salesmanName;
    }

    public String getReceiverCity()
    {
        return receiverCity;
    }

    public void setReceiverCity(String receiverCity)
    {
        this.receiverCity = receiverCity;
    }

    public String getInvoiceTitle()
    {
        return invoiceTitle;
    }

    public void setInvoiceTitle(String invoiceTitle)
    {
        this.invoiceTitle = invoiceTitle;
    }

    public BigDecimal getGoodsTypeCount()
    {
        return goodsTypeCount;
    }

    public void setGoodsTypeCount(BigDecimal goodsTypeCount)
    {
        this.goodsTypeCount = goodsTypeCount;
    }

    public BigDecimal getGoodsCount()
    {
        return goodsCount;
    }

    public void setGoodsCount(BigDecimal goodsCount)
    {
        this.goodsCount = goodsCount;
    }

    public BigDecimal getCodAmount()
    {
        return codAmount;
    }

    public void setCodAmount(BigDecimal codAmount)
    {
        this.codAmount = codAmount;
    }

    public String getFlagName()
    {
        return flagName;
    }

    public void setFlagName(String flagName)
    {
        this.flagName = flagName;
    }

    public String getReceiverTelno()
    {
        return receiverTelno;
    }

    public void setReceiverTelno(String receiverTelno)
    {
        this.receiverTelno = receiverTelno;
    }

    public String getReceiverZip()
    {
        return receiverZip;
    }

    public void setReceiverZip(String receiverZip)
    {
        this.receiverZip = receiverZip;
    }

    public String getWarehouseNo()
    {
        return warehouseNo;
    }

    public void setWarehouseNo(String warehouseNo)
    {
        this.warehouseNo = warehouseNo;
    }

    public String getInvoiceContent()
    {
        return invoiceContent;
    }

    public void setInvoiceContent(String invoiceContent)
    {
        this.invoiceContent = invoiceContent;
    }

    public Byte getTradeStatus()
    {
        return tradeStatus;
    }

    public void setTradeStatus(Byte tradeStatus)
    {
        this.tradeStatus = tradeStatus;
    }

    public BigDecimal getPostCost()
    {
        return postCost;
    }

    public void setPostCost(BigDecimal postCost)
    {
        this.postCost = postCost;
    }

    public String getReceiverName()
    {
        return receiverName;
    }

    public void setReceiverName(String receiverName)
    {
        this.receiverName = receiverName;
    }

    public BigDecimal getCommission()
    {
        return commission;
    }

    public void setCommission(BigDecimal commission)
    {
        this.commission = commission;
    }

    public Byte getInvoiceType()
    {
        return invoiceType;
    }

    public void setInvoiceType(Byte invoiceType)
    {
        this.invoiceType = invoiceType;
    }

    public String getCurrency()
    {
        return currency;
    }

    public void setCurrency(String currency)
    {
        this.currency = currency;
    }

    public BigDecimal getProfit()
    {
        return profit;
    }

    public void setProfit(BigDecimal profit)
    {
        this.profit = profit;
    }

    public Byte getTradeFrom()
    {
        return tradeFrom;
    }

    public void setTradeFrom(Byte tradeFrom)
    {
        this.tradeFrom = tradeFrom;
    }

    public Byte getDeliveryTerm()
    {
        return deliveryTerm;
    }

    public void setDeliveryTerm(Byte deliveryTerm)
    {
        this.deliveryTerm = deliveryTerm;
    }

    public String getLogisticsNo()
    {
        return logisticsNo;
    }

    public void setLogisticsNo(String logisticsNo)
    {
        this.logisticsNo = logisticsNo;
    }

    public BigDecimal getGoodsAmount()
    {
        return goodsAmount;
    }

    public void setGoodsAmount(BigDecimal goodsAmount)
    {
        this.goodsAmount = goodsAmount;
    }

    public BigDecimal getGoodsCost()
    {
        return goodsCost;
    }

    public void setGoodsCost(BigDecimal goodsCost)
    {
        this.goodsCost = goodsCost;
    }

    public String getReceiverDistrict()
    {
        return receiverDistrict;
    }

    public void setReceiverDistrict(String receiverDistrict)
    {
        this.receiverDistrict = receiverDistrict;
    }

    public String getStockoutNo()
    {
        return stockoutNo;
    }

    public void setStockoutNo(String stockoutNo)
    {
        this.stockoutNo = stockoutNo;
    }

    public BigDecimal getReceivable()
    {
        return receivable;
    }

    public void setReceivable(BigDecimal receivable)
    {
        this.receivable = receivable;
    }

    public Integer getVersionId()
    {
        return versionId;
    }

    public void setVersionId(Integer versionId)
    {
        this.versionId = versionId;
    }

    public String getReceiverMobile()
    {
        return receiverMobile;
    }

    public void setReceiverMobile(String receiverMobile)
    {
        this.receiverMobile = receiverMobile;
    }

    public String getBuyerNick()
    {
        return buyerNick;
    }

    public void setBuyerNick(String buyerNick)
    {
        this.buyerNick = buyerNick;
    }

    public Byte getFenxiaoType()
    {
        return fenxiaoType;
    }

    public void setFenxiaoType(Byte fenxiaoType)
    {
        this.fenxiaoType = fenxiaoType;
    }

    public String getCsRemark()
    {
        return csRemark;
    }

    public void setCsRemark(String csRemark)
    {
        this.csRemark = csRemark;
    }

    public Byte getPlatformId()
    {
        return platformId;
    }

    public void setPlatformId(Byte platformId)
    {
        this.platformId = platformId;
    }

    public Byte getTradeType()
    {
        return tradeType;
    }

    public void setTradeType(Byte tradeType)
    {
        this.tradeType = tradeType;
    }

    public String getReceiverAddress()
    {
        return receiverAddress;
    }

    public void setReceiverAddress(String receiverAddress)
    {
        this.receiverAddress = receiverAddress;
    }

    public String getLogisticsTypeName()
    {
        return logisticsTypeName;
    }

    public void setLogisticsTypeName(String logisticsTypeName)
    {
        this.logisticsTypeName = logisticsTypeName;
    }

    public BigDecimal getExtCodFee()
    {
        return extCodFee;
    }

    public void setExtCodFee(BigDecimal extCodFee)
    {
        this.extCodFee = extCodFee;
    }

    public String getCustomerName()
    {
        return customerName;
    }

    public void setCustomerName(String customerName)
    {
        this.customerName = customerName;
    }

    public String getTradeTime()
    {
        return tradeTime;
    }

    public void setTradeTime(String tradeTime)
    {
        this.tradeTime = tradeTime;
    }
}
