package cn.com.duiba.thirdparty.dto.wdt;

import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;
import java.math.BigDecimal;

public class RawTradeRefundOrderInfo implements Serializable {
    private static final long serialVersionUID = 717927569448948954L;
    // 取消订单
    public static Integer TYPE_CANCEL_ORDER = 0;
    // 退款(未发货，退款申请)
    public static Integer TYPE_APPLY_REFUND = 1;
    // 退货
    public static Integer TYPE_RETURN_GOOD = 2;
    // 换货
    public static Integer TYPE_EXCHANGE_GOOD = 3;
    // 退款不退换
    public static Integer TYPE_REFUND_NOT_RETURN_GOOD= 4;

    // 取消退款
    public static Integer STATUS_CANCEL_REFUND = 1;
    // 已申请退款
    public static Integer STATUS_APPLY_REFUND = 2;
    // 等待退货
    public static Integer STATUS_RETURN_GOOD = 3;
    // 等待收货
    public static Integer STATUS_WAIT_RECEIVE = 4;
    // 退款成功
    public static Integer STATUS_REFUND_SUCCESS = 5;

    //原始退款单号
    @JSONField(name = "refund_no")
    private String refundNo;

    //货品数量
    @JSONField(name = "num")
    private String num;

    //原始单号
    private String tid;

    //原始子单号
    private String oid;

    //退款单类型 0取消订单1退款(未发货，退款申请)2退货3换货4退款不退货
    private Integer type;

    //1取消退款,2已申请退款,3等待退货,4等待收货,5退款成功
    private Integer status;

    //退款版本，默认传1即可
    @JSONField(name = "refund_version")
    private String refundVersion;

    //申请退款金额
    @JSONField(name = "refund_amount")
    private BigDecimal refundAmount;

    //实际退款金额
    @JSONField(name = "actual_refund_amount")
    private BigDecimal actualRefundAmount;

    //标题，对应原始退款单页面主单货品字段
    @JSONField(name = "title")
    private String title;

    //物流公司名称（支持自定义推送
    @JSONField(name = "logistics_name")
    private String logisticsName;

    @JSONField(name = "logistics_no")
    private String logisticsNo;

    //客户网名
    @JSONField(name = "buyer_nick")
    private String buyerNick;

    //退款成功时间
    @JSONField(name = "current_phase_timeout")
    private String currentPhaseTimeout;

    //是否售后退款单
    @JSONField(name = "is_aftersale")
    private Boolean aftersale;

    //退款创建时间
    @JSONField(name = "refund_time")
    private String refundTime;

    public String getNum() {
        return num;
    }

    @JSONField(name = "reason")
    private String reason;

    public String getRefundNo() {
        return refundNo;
    }

    public void setRefundNo(String refundNo) {
        this.refundNo = refundNo;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public String getTid() {
        return tid;
    }


    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getOid() {
        return oid;
    }

    public void setOid(String oid) {
        this.oid = oid;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getRefundVersion() {
        return refundVersion;
    }

    public void setRefundVersion(String refundVersion) {
        this.refundVersion = refundVersion;
    }

    public BigDecimal getRefundAmount() {
        return refundAmount;
    }

    public void setRefundAmount(BigDecimal refundAmount) {
        this.refundAmount = refundAmount;
    }

    public BigDecimal getActualRefundAmount() {
        return actualRefundAmount;
    }

    public void setActualRefundAmount(BigDecimal actualRefundAmount) {
        this.actualRefundAmount = actualRefundAmount;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getLogisticsName() {
        return logisticsName;
    }

    public void setLogisticsName(String logisticsName) {
        this.logisticsName = logisticsName;
    }

    public String getLogisticsNo() {
        return logisticsNo;
    }

    public void setLogisticsNo(String logisticsNo) {
        this.logisticsNo = logisticsNo;
    }

    public String getBuyerNick() {
        return buyerNick;
    }

    public void setBuyerNick(String buyerNick) {
        this.buyerNick = buyerNick;
    }

    public String getCurrentPhaseTimeout() {
        return currentPhaseTimeout;
    }

    public void setCurrentPhaseTimeout(String currentPhaseTimeout) {
        this.currentPhaseTimeout = currentPhaseTimeout;
    }

    public Boolean getAftersale() {
        return aftersale;
    }

    public void setAftersale(Boolean aftersale) {
        this.aftersale = aftersale;
    }

    public String getRefundTime() {
        return refundTime;
    }

    public void setRefundTime(String refundTime) {
        this.refundTime = refundTime;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }
}
