package cn.com.duiba.thirdparty.dto.wdt;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author qiurenjie
 * @date 2023-06-21 17:40
 */
@JSONType(orders = {"shopNo","rawTradeList","rawTradeOrderList","discountList"})
public class ReturnMoneyParam implements Serializable {

    private static final long serialVersionUID = -3412047406855721803L;
    /**
     * 店铺编号
     */
    @JSONField(name = "shop_no")
    private String shopNo;

    /**
     * 原始单信息
     */
    @JSONField(name = "order_list")
    private List<RawTradeRefundOrderInfo> orderList;


    public String getShopNo() {
        return shopNo;
    }

    public void setShopNo(String shopNo) {
        this.shopNo = shopNo;
    }

    public List<RawTradeRefundOrderInfo> getOrderList() {
        return orderList;
    }

    public void setOrderList(List<RawTradeRefundOrderInfo> orderList) {
        this.orderList = orderList;
    }
}
