package cn.com.duiba.biz.alipay.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * 支付宝批量处理的日志
 */
public class AlipayBatchLogDO {

	private Long id;

	private String orderNums;

	private String requestUrl;

	private String batchNo;

	private String response;

	private String notifyContent;

	private Date gmtCreate;

	private Date gmtModified;

	public AlipayBatchLogDO() {
	}

	public AlipayBatchLogDO(Long id) {
		this.id = id;
		this.gmtModified = new Date();
	}

	public AlipayBatchLogDO(boolean insert) {
		if (insert) {
			gmtCreate = new Date();
			gmtModified = new Date();
		}
	}

	public List<String> getAllOrderNums() {
		if (orderNums == null) {
			return Collections.emptyList();
		}
		String[] o = orderNums.split(",");
		List<String> ret = new ArrayList<String>();
		for (String s : o) {
			ret.add(s);
		}
		return ret;
	}

	public void setAllOrderNums(List<String> orderNums) {
		StringBuffer sb = new StringBuffer();
		for (String o : orderNums) {
			sb.append(o + ",");
		}
		String on = sb.toString();
		if (on.endsWith(",")) {
			on = on.substring(0, on.length() - 1);
		}
		setOrderNums(on);
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getOrderNums() {
		return orderNums;
	}

	public void setOrderNums(String orderNums) {
		this.orderNums = orderNums;
	}

	public String getBatchNo() {
		return batchNo;
	}

	public void setBatchNo(String batchNo) {
		this.batchNo = batchNo;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public String getResponse() {
		return response;
	}

	public void setResponse(String response) {
		this.response = response;
	}

	public String getNotifyContent() {
		return notifyContent;
	}

	public void setNotifyContent(String notifyContent) {
		this.notifyContent = notifyContent;
	}

	public String getRequestUrl() {
		return requestUrl;
	}

	public void setRequestUrl(String requestUrl) {
		this.requestUrl = requestUrl;
	}
}
