package cn.com.duiba.biz.virtual.supplier;

import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.domain.MessageUniqueCheckDO;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.domain.SupplierResponse;
import cn.com.duiba.http.HttpClientService;
import cn.com.duiba.message.MessageService;
import cn.com.duiba.message.QueueConfig;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.tool.JsonTool;

@Service
public class VirtualSupplier {

	private static Logger log = LoggerFactory.getLogger(VirtualSupplier.class);

	@Autowired
	private MessageService messageService;
	@Autowired
	private QueueConfig queueConfig;

	public void asyncSubmit(final SupplierRequest message, final String callbackTopic) {
		if (!messageService.messageUniqueCheck(message.getSupplierOrderId(), MessageUniqueCheckDO.TYPE_VIRTUAL)) {
			return;
		}
		HttpRequestLog.logUrl("[action virtual] [tag request] [bizId " + message.getOrderId() + "] [url " + message.getHttpUrl() + "]");
		HttpGet get = new HttpGet(message.getHttpUrl());
		HttpClientService.get().submit(message.getAppId(), get, new FutureCallback<HttpResponse>() {

			@Override
			public void completed(HttpResponse response) {
				SupplierResponse resp = new SupplierResponse();
				try {
					resp.setOrderId(message.getOrderId());
					resp.setSupplierOrderId(message.getSupplierOrderId());
					resp.setSupplierName(message.getSupplierName());
					resp.setUrl(message.getHttpUrl());
					resp.setCallbackType(SupplierResponse.CALLBACK_TYPE_COMPLETED);
					resp.setAppId(message.getAppId());
					resp.setConsumerId(message.getConsumerId());
					String body = EntityUtils.toString(response.getEntity());
					resp.setBody(subBody(body));
				} catch (Exception e) {
					log.error("VirtualSupplier completed", e);
				} finally {
					finallyBlock(message, resp, callbackTopic);
				}
			}

			@Override
			public void failed(Exception ex) {
				log.error("VirtualSupplier failed orderId:" + message.getOrderId(), ex);
				SupplierResponse resp = new SupplierResponse();
				try {
					resp.setOrderId(message.getOrderId());
					resp.setSupplierOrderId(message.getSupplierOrderId());
					resp.setCallbackType(SupplierResponse.CALLBACK_TYPE_FAILED);
					resp.setAppId(message.getAppId());
					resp.setConsumerId(message.getConsumerId());
					resp.setErrorMessage(ex.getClass().getName() + ":" + ex.getMessage());
				} catch (Exception e) {
					log.error("VirtualSupplier completed", e);
				} finally {
					finallyBlock(message, resp, callbackTopic);
				}
			}

			@Override
			public void cancelled() {
				SupplierResponse resp = new SupplierResponse();
				try {
					resp.setOrderId(message.getOrderId());
					resp.setSupplierOrderId(message.getSupplierOrderId());
					resp.setCallbackType(SupplierResponse.CALLBACK_TYPE_CANCELLED);
					resp.setAppId(message.getAppId());
					resp.setConsumerId(message.getConsumerId());
				} catch (Exception e) {
					log.error("VirtualSupplier cancelled", e);
				} finally {
					finallyBlock(message, resp, callbackTopic);
				}
			}

		});

	}

	private String subBody(String text) {
		String body = text;
		if (body != null && body.length() > 2000) {
			body = body.substring(0, 2000);
		}
		return body;
	}

	private void finallyBlock(SupplierRequest message, SupplierResponse response, String callbackTopic) {
		try {
			HttpRequestLog.logUrl("[action virtual] [tag response] [bizId " + message.getOrderId() + "] [body " + response.getBody() + "] [callback " + response.getCallbackType() + "]");
			String body = JsonTool.objectToJson(response);
			messageService.sendMsg(callbackTopic, body);
		} catch (Exception e) {
			log.error("VirtualSupplier callback:" + message.getOrderId(), e);
		}
	}

}
