package cn.com.duiba.crecord.message;

import java.util.Date;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.crecord.service.HttpRetryRulesService;
import cn.com.duiba.credits.sdk.AssembleTool;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.dao.HttpMessageDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.HttpMessageDO;
import cn.com.duiba.http.HttpClientService;
import cn.com.duiba.message.QueueConfig;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;
import cn.com.duiba.thirdparty.dto.HttpResponseMessageDto;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.tool.ThreadPoolService;

import com.alibaba.fastjson.JSONObject;

@Service
public class CrecordAsyncHttp {

	private static Logger log = LoggerFactory.getLogger(CrecordAsyncHttp.class);

	@Autowired
	private QueueConfig queueConfig;
	@Autowired
	private HttpRetryRulesService httpRetryRulesService;
	@Autowired
	private AppDAO appDAO;
	@Autowired
	private HttpMessageDAO httpMessageDAO;

	public void asyncSubmit(final String message) {
		log.info(message);
		final HttpRequestMessageDto dto = JSONObject.parseObject(message, HttpRequestMessageDto.class);

		AppDO app = appDAO.findAppSimple(dto.getAppId());
		if (app == null || StringUtils.isEmpty(app.getRecordNotifyUrl())) {
			log.info("appId:" + dto.getAppId() + " recordNotifyUrl: is empty");
			return;
		}

		HttpMessageDO hmd = new HttpMessageDO();
		hmd.setAppId(dto.getAppId());
		hmd.setBizType(dto.getBizType());
		hmd.setBizParams(JSONObject.toJSONString(dto.getHttpParams()));
		hmd.setNumber(0);
		hmd.setGmtCreate(new Date());
		hmd.setGmtModified(new Date());
		hmd.setNextTime(httpRetryRulesService.getNextTime(hmd));
		httpMessageDAO.insert(hmd);

		asyncSubmit(hmd, dto, app);
	}

	public void asyncSubmit(final HttpMessageDO db, final HttpRequestMessageDto msg, AppDO app) {

		Map<String, String> map = msg.getHttpParams();
		map.put("appKey", app.getAppKey());
		map.put("appSecret", appDAO.getAppSecret(app));
		String sign = SignTool.sign(map);
		map.put("sign", sign);
		map.remove("appSecret");
		final String url = AssembleTool.assembleUrl(app.getRecordNotifyUrl(), map);

		HttpGet get = new HttpGet(url);
		HttpRequestLog.logUrl("[action crecord] [tag request] [url " + url + "]");
		HttpClientService.get().submit(msg.getAppId().toString(), get, new FutureCallback<HttpResponse>() {

			@Override
			public void completed(HttpResponse response) {
				HttpResponseMessageDto resp = new HttpResponseMessageDto();
				try {
					resp.setCallbackType(HttpResponseMessageDto.CALLBACK_TYPE_COMPLETED);
					resp.setHttpUrl(url);
					String body = EntityUtils.toString(response.getEntity());
					if (StringUtils.isNotEmpty(body)) {
						if (body.contains("ok") || body.contains("OK")) {
							resp.setSuccess(true);
						}
						if (body.length() > 2000) {
							body = body.substring(0, 2000);
						}
					}
					resp.setBody(body);
					resp.setBizId(msg.getBizId());
					resp.setBizType(msg.getBizType());
				} catch (Exception e) {
					resp.setSuccess(false);
					resp.setErrorMessage("请求失败:completed:" + e.getMessage());
					log.error("completed", e);
				} finally {
					httpRequestComleted(db, resp);
				}
			}

			@Override
			public void failed(Exception ex) {
				HttpResponseMessageDto resp = new HttpResponseMessageDto();
				resp.setCallbackType(HttpResponseMessageDto.CALLBACK_TYPE_FAILED);
				resp.setHttpUrl(url);
				resp.setBizId(msg.getBizId());
				resp.setBizType(msg.getBizType());
				resp.setSuccess(false);
				resp.setErrorMessage("请求失败:failed:" + ex.getMessage());
				httpRequestComleted(db, resp);
			}

			@Override
			public void cancelled() {
				HttpResponseMessageDto resp = new HttpResponseMessageDto();
				resp.setCallbackType(HttpResponseMessageDto.CALLBACK_TYPE_CANCELLED);
				resp.setHttpUrl(url);
				resp.setBizId(msg.getBizId());
				resp.setBizType(msg.getBizType());
				resp.setSuccess(false);
				resp.setErrorMessage("请求失败:cancelled");
				httpRequestComleted(db, resp);
			}

		});

	}

	private void httpRequestComleted(final HttpMessageDO db, final HttpResponseMessageDto resp) {
		HttpRequestLog.logUrl("[action crecord] [tag Response] [url " + resp.getHttpUrl() + "] [body " + resp.getBody() + "] [callback " + resp.getCallbackType() + "]");
		ThreadPoolService.get().submit(new Runnable() {
			@Override
			public void run() {
				try {
					if (!HttpResponseMessageDto.CALLBACK_TYPE_COMPLETED.equals(resp.getCallbackType())) {
						if (db.getNumber() >= httpRetryRulesService.getRetryNumber(db)) {
							httpMessageDAO.delete(db.getId());
						} else {
							Date nextTime = httpRetryRulesService.getNextTime(db);
							httpMessageDAO.updateNextTime(db.getId(), nextTime);
						}
					} else {
						httpMessageDAO.delete(db.getId());
					}
				} catch (Exception e) {
					log.error("httpRequestComleted", e);
				}
			}
		});

	}

}
