package cn.com.duiba.crecord.service;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import cn.com.duiba.crecord.message.CrecordAsyncHttp;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.dao.HttpMessageDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.HttpMessageDO;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;

import com.alibaba.fastjson.JSONObject;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.dangdang.ddframe.job.plugin.job.type.simple.AbstractSimpleElasticJob;

@Component
public class CrecordHttpRetryJob extends AbstractSimpleElasticJob {

	private Logger log = LoggerFactory.getLogger(CrecordHttpRetryJob.class);

	@Autowired
	private HttpMessageDAO httpMessageDAO;
	@Autowired
	private CrecordAsyncHttp toDeveloper;
	@Autowired
	private AppDAO appDAO;
	
	@Value("${notifycenter.timer.enable}")
	private boolean timerEnable;

	@SuppressWarnings("unchecked")
	@Override
	public void process(JobExecutionMultipleShardingContext shardingContext) {
		try {
			if(!timerEnable){
				return;
			}
			Date start = new Date();
			log.info("CrecordHttpRetryJob start:" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(start));
			List<HttpMessageDO> dos = httpMessageDAO.findNeedRetry(HttpRequestMessageDto.RETRY_CRECORD, 5000);
			Map<Long, AppDO> appMap = new HashMap<>();
			Set<Long> appIds = new HashSet<>();
			for (HttpMessageDO db : dos) {
				appIds.add(db.getAppId());
			}
			for (Long appId : appIds) {
				AppDO app = appDAO.findAppSimple(appId);
				appMap.put(appId, app);
			}
			for (HttpMessageDO db : dos) {
				AppDO app = appMap.get(db.getAppId());
				HttpRequestMessageDto dto = new HttpRequestMessageDto();
				dto.setAppId(db.getAppId());
				dto.setBizType(db.getBizType());
				Map<String, String> httpParams = JSONObject.parseObject(db.getBizParams(), Map.class);
				dto.setHttpParams(httpParams);
				toDeveloper.asyncSubmit(db, dto, app);
			}
			Date end = new Date();
			log.info("CrecordHttpRetryJob end:" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(end) + " size:" + dos.size() + " time:" + (end.getTime() - start.getTime()) + "ms");
		} catch (Exception e) {
			log.error("CrecordHttpRetryJob error:", e);
		}
	}

}
