package cn.com.duiba.crecord.service.impl;

import java.util.Date;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import cn.com.duiba.crecord.service.HttpRetryRulesService;
import cn.com.duiba.domain.HttpMessageDO;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;

@Service
public class HttpRetryRulesServiceImpl implements HttpRetryRulesService {

	@Value("${default.retry.time}")
	private String defaultRetryConfig;

	@Value("${addCredits.retry.time}")
	private String addCreditsRetryConfig;

	@Override
	public String[] getDefaultRetry() {
		return defaultRetryConfig.split(",");
	}

	private String[] getAddCreditsRetry() {
		return addCreditsRetryConfig.split(",");
	}

	@Override
	public String[] getRetryRule(HttpMessageDO db) {
		if (HttpRequestMessageDto.RETRY_ADD_CREDITS.equals(db.getBizType())) {
			return getAddCreditsRetry();
		}
		return getDefaultRetry();
	}

	@Override
	public Date getNextTime(HttpMessageDO db) {
		int next = db.getNumber();
		String[] seconds = getRetryRule(db);
		Integer second = Integer.valueOf(seconds[next]);
		Long times = second * 1000L;
		return new Date(System.currentTimeMillis() + times);
	}

	@Override
	public Integer getRetryNumber(HttpMessageDO db) {
		String[] retry = getRetryRule(db);
		return retry.length;
	}

}
