package cn.com.duiba.dao.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.dao.BaseDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.tool.DuibaPropertySourceLoader;
import cn.com.duiba.wolf.utils.BlowfishUtils;

@Repository("appDAO")
public class AppDAOImpl extends BaseDAO implements AppDAO {

	private static Logger log = LoggerFactory.getLogger(AppDAOImpl.class);

	@Value("${app.secret.key}")
	private String appSecretKey;

	@Autowired
	private DuibaPropertySourceLoader duibaPropertySourceLoader;

	@Override
	public AppDO findAppSimple(Long id) {
		return getSqlSession().selectOne(getStamentNameSpace("findAppSimple"), id);
	}

	@Override
	public String getAppSecret(AppDO app) {
		log.info("after secret:" + appSecretKey);
		return BlowfishUtils.decryptBlowfish(app.getSecretCode(), appSecretKey);
	}

	public String getAppSecretKey() {
		return appSecretKey;
	}

	public void setAppSecretKey(String appSecretKey) {
		this.appSecretKey = appSecretKey;
	}

}
