package cn.com.duiba.domain;

import cn.com.duiba.tool.HttpRequestLog;

public class SupplierLog {

	public static final String TAG_BEFORSEND = "BeforSend";
	public static final String TAG_RESPONS = "Response";

	private String tag;
	private String orderId;
	private String supplierOrderId;
	private String url;
	private String body;
	private String callback;

	public String getTag() {
		return tag;
	}

	public void setTag(String tag) {
		this.tag = tag;
	}

	public String getOrderId() {
		return orderId;
	}

	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public String getSupplierOrderId() {
		return supplierOrderId;
	}

	public void setSupplierOrderId(String supplierOrderId) {
		this.supplierOrderId = supplierOrderId;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getCallback() {
		return callback;
	}

	public void setCallback(String callback) {
		this.callback = callback;
	}

	public String getBody() {
		return body;
	}

	public void setBody(String body) {
		this.body = body;
	}

	public static void requestLog(String orderId, String supplierOrderId, String url) {
		HttpRequestLog.log.info("[orderId " + orderId + "] [supplierOrderId " + supplierOrderId + "] [tag " + SupplierLog.TAG_BEFORSEND + "] [url " + url + "]");
	}

	public static void responseLog(SupplierLog httpLog) {
		HttpRequestLog.log.info("[orderId " + httpLog.getOrderId() + "] [supplierOrderId " + httpLog.getSupplierOrderId() + "] [tag " + SupplierLog.TAG_RESPONS + "] [url " + httpLog.getUrl() + "] [body " + httpLog.getBody() + "] [callback " + httpLog.getCallback() + "]");
	}

}
