package cn.com.duiba.http;

import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.protocol.HttpContext;

public class HttpClientService extends AbstractHttpAsyncClientPool {

	public static final HttpClientService instance = new HttpClientService();

	/**
	 * 连接超时
	 */
	public static final int CONNECT_TIMEOUT = 30 * 1000;

	/**
	 * 长链接空闲时间
	 */
	public static final int KEEPALIVE_TIMEOUT = 30 * 1000;

	/**
	 * 处理超时
	 */
	public static final int SOCKET_TIMEOUT = 30 * 1000;

	/**
	 * 最大总连接值
	 */
	public static final int MAX_CONNECT = 4096;

	/**
	 * 每个路由最大连接{并发}值
	 */
	public static final int MAX_ROUTE_CONNECT = 128;

	/**
	 * APP最大处理队列
	 */
	public static final int MAX_APP_QUEUE = 100;
	

	public static HttpClientService get() {
		return instance;
	}

	@Override
	public CloseableHttpAsyncClient getHttpAsyncClient() {
		return HttpAsyncClients.custom().setDefaultRequestConfig(getRequestConfig()).setMaxConnTotal(MAX_CONNECT).setMaxConnPerRoute(MAX_ROUTE_CONNECT).setKeepAliveStrategy(getKeepAliveStrategy()).build();
	}

	/**
	 * 长链接空闲时间
	 */
	public DefaultConnectionKeepAliveStrategy getKeepAliveStrategy() {
		return new DefaultConnectionKeepAliveStrategy() {
			@Override
			public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
				long duration = super.getKeepAliveDuration(response, context);
				if (duration == -1) {
					return KEEPALIVE_TIMEOUT;
				}
				return duration;
			}
		};
	}

	public RequestConfig getRequestConfig() {
		return RequestConfig.custom().setConnectTimeout(CONNECT_TIMEOUT).setConnectionRequestTimeout(CONNECT_TIMEOUT).setSocketTimeout(SOCKET_TIMEOUT).build();
	}


	@Override
	public int getAppMaxQueue() {
		return MAX_APP_QUEUE;
	}

	@Override
	public int getMaxQueue() {
		return MAX_CONNECT;
	}

}
