package cn.com.duiba.message;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Component;

import cn.com.duiba.dao.MessageUniqueCheckDAO;
import cn.com.duiba.domain.MessageUniqueCheckDO;

@Component
public class MessageService {

	private static Logger log = LoggerFactory.getLogger(MessageService.class);

	@Autowired
	private KafkaClient kafkaClient;
	@Autowired
	private MessageUniqueCheckDAO messageUniqueCheckDAO;

	/**
	 * 发送消息，失败尝试3次
	 * 
	 * @param queueName
	 *            队列名单
	 * @param body
	 *            消息内容
	 * @return
	 * @throws Exception
	 */
	public String sendMsg(String queueName, String body) {
		return kafkaClient.sendMsg(queueName, body);
	}

	public boolean messageUniqueCheck(String relationId, String relationType) {
		try {
			MessageUniqueCheckDO check = new MessageUniqueCheckDO();
			check.setRelationId(relationId);
			check.setRelationType(relationType);
			messageUniqueCheckDAO.insert(check);
			return true;
		} catch (DuplicateKeyException e) {
			log.error("重复向上游请求 supplierOrderId:" + relationId + " DuplicateKeyException",e);
		}
		return false;
	}

}
