package cn.com.duiba.notifycenter.service;

import java.util.Date;

import cn.com.duiba.notifycenter.domain.NotifyQueueDO;

public interface NotifyService {

	/**
	 * 通知开发者
	 * 
	 * @param NotifyQueueDO
	 */
	public void notify(NotifyQueueDO queue);

	/**
	 * 获取下次通知时间
	 * 
	 * @param NotifyQueueDO
	 * @return 下一次通知时间
	 */
	public Date getNextTime(NotifyQueueDO queue);

	/**
	 * 扫描数据库中需要通知的记录，进行通知处理
	 */
	public void scan();
}
