package cn.com.duiba.notifycenter.service.impl;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.credits.sdk.AssembleTool;
import cn.com.duiba.credits.sdk.CreditNotifyParams;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.notifycenter.service.BussinessTypesService;
import cn.com.duiba.tool.DuibaPropertySourceLoader;
import cn.com.duiba.tool.Environment;

@Service("bussinessTypesService")
public class BusinessTypeServiceImpl implements BussinessTypesService {

	@Autowired
	private Environment environment;
	@Autowired
	private AppDAO appDAO;
	@Autowired
	private DuibaPropertySourceLoader duibaPropertySourceLoader;



	@Override	
	public HttpUriRequest getRequest(NotifyQueueDO record) {
		AppDO app = appDAO.findAppSimple(record.getAppId());

		if (app.getCreditsConsumeNotifyUrl() == null || app.getCreditsConsumeNotifyUrl().length() == 0) {
			return null;
		}

		String errorMessage = "";
		if (record.getError4developer() != null) {
			errorMessage = record.getError4developer();
		}
		String uid = record.getPartnerUserId();
		if (uid == null) {
			uid = "";
		}
		String bizId = "";
		if (record.getDeveloperBizId() != null) {
			bizId = record.getDeveloperBizId();
		}

		CreditNotifyParams p = new CreditNotifyParams();
		p.setSuccess(record.getResult());
		p.setErrorMessage(errorMessage);
		p.setAppKey(app.getAppKey());
		p.setBizId(bizId);
		p.setUid(uid);
		p.setOrderNum(record.getDuibaOrderNum());

		Map<String, String> map = p.toRequestMap(appDAO.getAppSecret(app));
		final String url = AssembleTool.assembleUrl(app.getCreditsConsumeNotifyUrl(), map);

		HttpRequestBase request;
		if (Environment.PLACE_BAIDUYUN.equals(environment.getPlace())) {
			request = assembleRequest(app.getCreditsConsumeNotifyUrl(), map);
			request.setConfig(getDefaultConfig());
		} else {
			request = new HttpGet(url);
			request.setConfig(getDefaultConfig());
		}
		return request;
	}

	private RequestConfig getDefaultConfig() {
		return RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
	}

	private HttpPost assembleRequest(String url, Map<String, String> params) {
		List<NameValuePair> pairs = new ArrayList<>(params.size());
		for (Map.Entry<String, String> entry : params.entrySet()) {
			String value = entry.getValue();
			if (value != null) {
				pairs.add(new BasicNameValuePair(entry.getKey(), value));
			}
		}
		HttpPost post = new HttpPost(url);
		post.setEntity(new UrlEncodedFormEntity(pairs, Charset.forName("utf-8")));
		return post;
	}

}
