package cn.com.duiba.remoteimpl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.biz.alipay.domain.AlipayOfficialRequest;
import cn.com.duiba.biz.alipay.supplier.AlipayBatchExecutor;
import cn.com.duiba.biz.alipay.supplier.ZhongXiangSupplier;
import cn.com.duiba.biz.phonebill.supplier.GyjxPhonebillSupplier;
import cn.com.duiba.biz.phonebill.supplier.LianLianPhonebillSupplier;
import cn.com.duiba.biz.phonebill.supplier.NewLianLianPhonebillSupplier;
import cn.com.duiba.biz.phonebill.supplier.OufeiPhonebillSupplier;
import cn.com.duiba.biz.phonebill.supplier.SududaPhonebillSupplier;
import cn.com.duiba.biz.phoneflow.supplier.MoPinPhoneflowSupplier;
import cn.com.duiba.biz.qb.supplier.EnlianQBSupplier;
import cn.com.duiba.biz.qb.supplier.GoukaQBSupplier;
import cn.com.duiba.biz.qb.supplier.TencentQBSupplier;
import cn.com.duiba.biz.virtual.supplier.VirtualSupplier;
import cn.com.duiba.domain.SupplierProductDO;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.thirdparty.api.RemoteChargeService;
import cn.com.duiba.thirdparty.dto.AlipayOfficialRequestDto;
import cn.com.duiba.thirdparty.dto.SupplierRequestDto;
import cn.com.duiba.tool.CodeException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * 直冲类接口请求远程服务实现类
 */
@Service
public class RemoteChargeServiceImpl implements RemoteChargeService {

	private static final Logger LOGGER = LoggerFactory.getLogger(RemoteChargeServiceImpl.class);

	@Autowired
	private AlipayBatchExecutor alipayBatchExecutor;
	@Autowired
	private ZhongXiangSupplier zhongXiangSupplier;
	@Autowired
	private EnlianQBSupplier enlianQBSupplier;
	@Autowired
	private GoukaQBSupplier goukaQBSupplier;
	@Autowired
	private TencentQBSupplier tencentQBSupplier;
	@Autowired
	private GyjxPhonebillSupplier gyjxPhonebillSupplier;
	@Autowired
	private OufeiPhonebillSupplier oufeiPhonebillSupplier;
	@Autowired
	private SududaPhonebillSupplier sududaPhonebillSupplier;
	@Autowired
	private LianLianPhonebillSupplier lianLianPhonebillSupplier;
	@Autowired
	private NewLianLianPhonebillSupplier newLianLianPhonebillSupplier;
	@Autowired
	private MoPinPhoneflowSupplier moPinPhoneflowSupplier;
	@Autowired
	private VirtualSupplier virtualSupplier;

	/**
	 * 提交官方支付宝请求
	 */
	@Override
	public DubboResult<Boolean> submitAlipay(AlipayOfficialRequestDto request) {
		try {
			AlipayOfficialRequest req = BeanUtils.copy(request, AlipayOfficialRequest.class);
			alipayBatchExecutor.addAlipayOrder(req);
			return DubboResult.successResult(true);
		} catch (Exception e) {
			LOGGER.error("submitAlipay", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	/**
	 * 提交众想支付宝接口请求
	 */
	@Override
	public DubboResult<Boolean> submitZxAlipay(SupplierRequestDto supplierRequestDto, String callbackTopic) {
		try {
			SupplierRequest sr = BeanUtils.copy(supplierRequestDto, SupplierRequest.class);
			zhongXiangSupplier.asyncSubmit(sr, callbackTopic);
			return DubboResult.successResult(true);
		} catch (Exception e) {
			LOGGER.error("submitZxAlipay", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	/**
	 * 提交QB接口请求
	 */
	@Override
	public DubboResult<Boolean> submitQb(SupplierRequestDto request, String callbackTopic) {
		try {
			SupplierRequest req = BeanUtils.copy(request, SupplierRequest.class);
			if (SupplierProductDO.SupplierQBTencent.equals(request.getSupplierName())) {
				tencentQBSupplier.asyncSubmit(req, callbackTopic);
			} else if (SupplierProductDO.SupplierQBEnlian.equals(request.getSupplierName())) {
				enlianQBSupplier.asyncSubmit(req, callbackTopic);
			} else if (SupplierProductDO.SupplierQBGouka.equals(request.getSupplierName())) {
				goukaQBSupplier.asyncSubmit(req, callbackTopic);
			} else {
				throw new CodeException("0", "QB无对应上游：" + request.getSupplierName());
			}
			return DubboResult.successResult(true);
		} catch (Exception e) {
			LOGGER.error("submitQb", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	/**
	 * 提交话费接口请求
	 */
	@Override
	public DubboResult<Boolean> submitPhonebill(SupplierRequestDto supplierRequestDto, String callbackTopic) {
		try {
			SupplierRequest request = BeanUtils.copy(supplierRequestDto, SupplierRequest.class);
			if (SupplierProductDO.SupplierPhonebillGyjx.equals(request.getSupplierName())) {
				gyjxPhonebillSupplier.asyncSubmit(request, callbackTopic);
			} else if (SupplierProductDO.SupplierPhonebillOufei.equals(request.getSupplierName())) {
				oufeiPhonebillSupplier.asyncSubmit(request, callbackTopic);
			} else if (SupplierProductDO.SupplierPhonebillNewLianlian.equals(request.getSupplierName())) {
				newLianLianPhonebillSupplier.asyncSubmit(request, callbackTopic);
			} else if (SupplierProductDO.SupplierPhonebillLianlian.equals(request.getSupplierName())) {
				lianLianPhonebillSupplier.asyncSubmit(request, callbackTopic);
			} else if (SupplierProductDO.SupplierPhonebillSududa.equals(request.getSupplierName())) {
				sududaPhonebillSupplier.asyncSubmit(request, callbackTopic);
			} else {
				throw new CodeException("0", "phonebill无对应上游：" + request.getSupplierName());
			}
			return DubboResult.successResult(true);
		} catch (Exception e) {
			LOGGER.error("submitPhonebill", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	/**
	 * 提交流量接口请求
	 */
	@Override
	public DubboResult<Boolean> submitPhoneflow(SupplierRequestDto supplierRequestDto, String callbackTopic) {
		try {
			SupplierRequest request = BeanUtils.copy(supplierRequestDto, SupplierRequest.class);
			moPinPhoneflowSupplier.asyncSubmit(request, callbackTopic);
			return DubboResult.successResult(true);
		} catch (Exception e) {
			LOGGER.error("submitPhoneflow", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	/**
	 * 提交虚拟商品接口请求
	 */
	@Override
	public DubboResult<Boolean> submitVirtual(SupplierRequestDto supplierRequestDto, String callbackTopic) {
		try {
			SupplierRequest request = BeanUtils.copy(supplierRequestDto, SupplierRequest.class);
			virtualSupplier.asyncSubmit(request, callbackTopic);
			return DubboResult.successResult(true);
		} catch (Exception e) {
			LOGGER.error("submitVirtual", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

}
