package cn.com.duiba.remoteimpl;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.http.HttpClientService;
import cn.com.duiba.service.CreditsService;
import cn.com.duiba.thirdparty.api.RemoteCreditsService;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;
import cn.com.duiba.tool.CodeException;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 扣/加积分 远程服务实现类
 */
@Service
public class RemoteCreditsServiceImpl implements RemoteCreditsService {

	private static final Logger LOG = LoggerFactory.getLogger(RemoteCreditsServiceImpl.class);

	@Autowired
	private CreditsService creditsService;

	/**
	 * 提交扣积分请求
	 */
	@Override
	public DubboResult<Boolean> submitSubCredits(HttpRequestMessageDto request, String callbackTopic) {
		try {
			validate(request, callbackTopic);
			creditsService.subCredits(request, callbackTopic);
			return DubboResult.successResult(true);
		} catch (CodeException e) {
			LOG.error("submitSubCredits", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	/**
	 * 提交加积分请求
	 */
	@Override
	public DubboResult<Boolean> submitAddCredits(HttpRequestMessageDto request, String callbackTopic) {
		try {
			validate(request, callbackTopic);
			creditsService.addCredits(request, callbackTopic);
			return DubboResult.successResult(true);
		} catch (CodeException e) {
			LOG.error("submitSubCredits", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	/**
	 * 验证提交请求
	 * 
	 * @param request
	 * @param callbackTopic
	 * @throws CodeException
	 */
	private void validate(HttpRequestMessageDto request, String callbackTopic) throws CodeException {
		if (request == null) {
			throw new CodeException("0", "参数校验失败");
		}
		if (StringUtils.isEmpty(callbackTopic)) {
			throw new CodeException("0", "订阅Topic不能为空");
		}
		if (StringUtils.isEmpty(request.getHttpUrl())) {
			throw new CodeException("0", "请求URL不能为空");
		}
		if (request.getAppId() == null) {
			throw new CodeException("0", "APPID不能为空");
		}
		if (!HttpClientService.get().canSubmitToAppPool(request.getAppId().toString())) {
			throw new CodeException("0", "APP队列超过阀值，APP接口繁忙");
		}
	}
}
