package cn.com.duiba.tool;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssembleTool {
	
	private static Logger log = LoggerFactory.getLogger(AssembleTool.class);
	
	private AssembleTool() {
	}

	public static String assembleUrl(String urlPar, Map<String, String> params) {
		StringBuffer str = new StringBuffer(urlPar);
		if (str.toString().contains("?")) {
			str.append("&");
		} else {
			str.append("?");
		}
		for (Map.Entry<String,String> entry : params.entrySet()) {
			try {
				if (entry.getValue() == null || entry.getValue().length() == 0) {
					str.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
				} else {
					str.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), "utf-8")).append("&");
				}
			} catch (UnsupportedEncodingException e) {
				log.error("assembleUrl",e);
			}
		}
		return str.toString();
	}

	public static HttpPost assembleRequest(String url, Map<String, String> argParams) {
		Map<String, String> params = argParams;
		if(params==null){
			params = new HashMap<>();
		}
		List<NameValuePair> pairs = new ArrayList<>(params.size());
		for (Map.Entry<String, String> entry : params.entrySet()) {
			String value = entry.getValue();
			if (value != null) {
				pairs.add(new BasicNameValuePair(entry.getKey(), value));
			}
		}
		HttpPost post = new HttpPost(url);
		post.setEntity(new UrlEncodedFormEntity(pairs, Charset.forName("utf-8")));
		return post;
	}

	public static String paramsToUrl(Map<String, String> params) {
		StringBuffer sb = new StringBuffer();
		for (Map.Entry<String, String> entry : params.entrySet()) {
			String value = entry.getValue();
			if (value != null) {
				sb.append(value).append("&");
			}
		}
		return sb.toString();
	}

}
