package cn.com.duiba.tool;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.fasterxml.jackson.databind.ObjectMapper;

public class JsonTool {

	private static Logger log = LoggerFactory.getLogger(JsonTool.class);

	private JsonTool() {
	}

	public static String objectToJson(Object object) {
		String json = null;
		try {
			ObjectMapper mapper = new ObjectMapper();
			json = mapper.writeValueAsString(object);
		} catch (Exception e) {
			log.error("objectToJson", e);
		}
		return json;
	}

	public static <T> T jsonToObject(String json, Class<T> clazz) {
		try {
			ObjectMapper mapper = new ObjectMapper();
			return mapper.readValue(json, clazz);
		} catch (Exception e) {
			log.error("jsonToObject", e);
		}
		return null;
	}

}
