package cn.com.duiba.tool;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;

public class ThreadPoolService {

	/**
	 * 线程池最大线程数
	 */
	public static final int MAX_THREAD = 10;

	private ExecutorService pool = Executors.newFixedThreadPool(MAX_THREAD);

	private static ThreadPoolService service = new ThreadPoolService();

	private ThreadPoolService() {

	}

	public static ThreadPoolService get() {
		return service;
	}

	/**
	 * 提交任务<br/>
	 * Runnable run方法一定要捕获异常
	 */
	public void submit(Runnable runnable) {
		pool.submit(runnable);
	}

	public int dumpSize() {
		return ((ThreadPoolExecutor) pool).getActiveCount();
	}

}
