package cn.com.duiba.biz.credits;

import cn.com.duiba.dao.HttpMessageDAO;
import cn.com.duiba.domain.HttpMessageDO;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.dangdang.ddframe.job.plugin.job.type.simple.AbstractSimpleElasticJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 加积分异常重试的定时任务
 */
@Component
public class AddCreditsRetryJob extends AbstractSimpleElasticJob {

	private Logger log = LoggerFactory.getLogger(AddCreditsRetryJob.class);

	@Value("${notifycenter.timer.enable}")
	private boolean timerEnable;

	@Autowired
	private HttpMessageDAO httpMessageDAO;

	@Autowired
	private AddCreditsToDeveloper addCreditsToDeveloper;

	@Autowired
	private HttpAsyncClientPool httpAsyncClientPool;

	@Override
	public void process(JobExecutionMultipleShardingContext shardingContext) {
		if (!timerEnable) {
			return;
		}
		long s = System.currentTimeMillis();
		List<HttpMessageDO> dos = httpMessageDAO.findNeedRetry(HttpRequestMessageDto.RETRY_ADD_CREDITS, 2000);
		for (HttpMessageDO db : dos) {
			if (httpAsyncClientPool.canSubmitToAppPool(db.getAppId().toString())) {
				addCreditsToDeveloper.submit(db);
			} else {
				log.warn("scan cannot be submit to {} queue", db.getAppId());
			}
		}
		long e = System.currentTimeMillis();
		log.info("addCredits scan size:{} time:{} ms", dos.size(), (e - s));
	}

}
