package cn.com.duiba.biz.credits;

import cn.com.duiba.boot.ext.autoconfigure.accesslog.MD5;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.tool.AssembleTool;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;


/**
 * 摩拜对接API
 */
@Service
public class MobikeApi {



    public static final String MOBIKE_CLIENT_ID="duiba";
    public static final String MOBILE_SECRET="4b6bafac8a839294a1329cd5bf90b83b";

    public static final String TEST_MOBILE_SECRET="dbsecret";

    public static final long MOBIKE_TEST_ID=35830L;

    public static String getMobikeNotifyUrl(String url,NotifyQueueDO record,String time){
        TreeMap<String ,String> params=new TreeMap<>();
        params.put("timestamp",String.valueOf(System.currentTimeMillis()));
        params.put("success",String.valueOf(record.getResult()));
        if(StringUtils.isNotEmpty(record.getError4developer())) {
            params.put("errorMessage", record.getError4developer());
        }
        params.put("orderNum",record.getDuibaOrderNum());
        if(StringUtils.isNotEmpty(record.getDeveloperBizId())){
            params.put("bizId",record.getDeveloperBizId());
        }
        params.put("accesstoken",record.getTransfer());
        params.put("client_id",MOBIKE_CLIENT_ID);
        params.put("time",time);
        params.put("sign",getMobileSign(params,getSecret(record.getAppId())));
        return AssembleTool.assembleUrl(url, params);
    }

    public static String getSecret(Long appId){
        if(Objects.equals(appId, MOBIKE_TEST_ID)){
            return TEST_MOBILE_SECRET;
        }
        return MOBILE_SECRET;
    }

    private static boolean isTestAPP(Long appId) {
        if (Objects.equals(appId, MOBIKE_TEST_ID)) {
            return true;
        }
        return false;
    }

    public static SupplierRequest getVirtualRequest(SupplierRequest request){

        String url = request.getHttpUrl();
        String host = url.substring(0, url.indexOf('?'));
        String urlParams = url.substring(url.indexOf('?') + 1, url.length());
        // 1.将请求URL的参数转换为MAP
        Map<String, String> crediMap = AssembleTool.getUrlParams(urlParams);
        TreeMap<String,String> params=new TreeMap<>();

        params.put("accesstoken",crediMap.get("transfer"));
        params.put("client_id",MOBIKE_CLIENT_ID);
        params.put("timestamp",String.valueOf(System.currentTimeMillis()));
        params.put("uid",crediMap.get("uid"));
        params.put("credits","100");//目前固定100
        params.put("bizCredits",request.getParams().get("bizCredits"));
        params.put("params",crediMap.get("params"));//虚拟商品标识符
        params.put("description",crediMap.get("description"));
        params.put("developBizId",crediMap.get("developBizId"));
        params.put("orderNum",crediMap.get("orderNum"));
        String account=crediMap.get("account");
        if (StringUtils.isNotEmpty(account)) {
            params.put("account", account);
        }
        if(isTestAPP(Long.valueOf(request.getAppId()))){
            params.put("duibatest","true");
        }
        String time=String.valueOf(System.currentTimeMillis()/1000L);
        params.put("time",time);
        params.put("sign",getMobileSign(params,getSecret(Long.valueOf(request.getAppId()))));

        String requestUrl = AssembleTool.assembleUrl(host, params);
        request.setHttpUrl(requestUrl);
        //构造需要设置到header中的参数
        request.getParams().put("time",time);
        request.getParams().put("accesstoken",crediMap.get("transfer"));
        return request;
    }

    /**
     * 构造摩拜定制扣积分请求
     * @param creditsMessage
     * @return
     */
    public CreditsMessage buildSubCreditsRequest(CreditsMessage creditsMessage){

        String url = creditsMessage.getHttpUrl();
        String host = url.substring(0, url.indexOf('?'));
        String urlParams = url.substring(url.indexOf('?') + 1, url.length());
        // 1.将请求URL的参数转换为MAP
        Map<String, String> crediMap = AssembleTool.getUrlParams(urlParams);

        TreeMap<String,String> params=new TreeMap<>();
        params.put("accesstoken",crediMap.get("transfer"));
        params.put("client_id",MOBIKE_CLIENT_ID);
        params.put("timestamp",String.valueOf(System.currentTimeMillis()));
        params.put("uid",crediMap.get("uid"));
        params.put("bizCredits",creditsMessage.getParams().get("bizCredits"));
        params.put("credits","100");//目前固定100
        String itemCode=crediMap.get("itemCode");
        if(StringUtils.isNotEmpty(itemCode)) {
            params.put("itemCode", itemCode);
        }
        String description=crediMap.get("description");
        if(StringUtils.isNotEmpty(description)) {
            params.put("description",description);
        }
        params.put("orderNum",crediMap.get("orderNum"));
        params.put("type",crediMap.get("type"));
        params.put("facePrice",crediMap.get("facePrice"));
        params.put("actualPrice",crediMap.get("actualPrice"));
        String ip=crediMap.get("ip");
        if(StringUtils.isNotEmpty(ip)){
            params.put("ip",ip);
        }
        params.put("waitAudit",crediMap.get("waitAudit"));
        String detailParams=crediMap.get("params");//详情参数
        if(StringUtils.isNotEmpty(detailParams)) {
            params.put("params", detailParams);
        }
        params.put("appItemId",creditsMessage.getParams().get("appItemId"));

        String time=String.valueOf(System.currentTimeMillis()/1000L);
        params.put("time",time);
        //构造需要设置到header中的参数
        creditsMessage.getParams().put("time",time);
        creditsMessage.getParams().put("accesstoken",crediMap.get("transfer"));

        params.put("sign",getMobileSign(params,getSecret(Long.valueOf(creditsMessage.getAppId()))));

        String requestUrl = AssembleTool.assembleUrl(host, params);
        creditsMessage.setHttpUrl(requestUrl);
        creditsMessage.setHttpType(CreditsMessage.HTTP_POST);
        return creditsMessage;
    }



    private static String getMobileSign(TreeMap<String,String> params, String secret) {
        Set<String> keys=params.keySet();
        StringBuilder builder=new StringBuilder();
        for(String key:keys){
            if(builder.length()>0){
                builder.append("&");
            }
            builder.append(key);
            builder.append("=");
            builder.append(params.get(key));
        }
        builder.append("@");
        builder.append(secret);
        try {
            return MD5.md5(builder.toString());
        } catch (NoSuchAlgorithmException e) {
            return null;
        } catch (UnsupportedEncodingException e) {
            return null;
        }
    }


}
