package cn.com.duiba.notifycenter.remoteimpl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.notifycenter.dao.NotifyQueueDAO;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.notifycenter.service.NotifyService;
import cn.com.duiba.thirdparty.api.RemoteNotifyDeveloperService;
import cn.com.duiba.thirdparty.dto.NotifyQueueDto;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * 通知服务接口
 */
@Service
public class RemoteNotifyQueueServiceImpl implements RemoteNotifyDeveloperService {

	private static Logger log = LoggerFactory.getLogger(RemoteNotifyQueueServiceImpl.class);

	@Autowired
	private NotifyQueueDAO notifyQueueDAO;
	@Autowired
	private NotifyService notifyService;

	@Override
	public void notifyDeveloper(NotifyQueueDto notifyQueue) {
		try {
			NotifyQueueDO queue = BeanUtils.copy(notifyQueue, NotifyQueueDO.class);
			DBTimeProfile.enter("insert");
			notifyQueueDAO.insert(queue);
			DBTimeProfile.release();
			DBTimeProfile.enter("notify");
			notifyService.notify(queue, "remote call");
			DBTimeProfile.release();
		} catch (Exception e) {
			log.error("notify error", e);
		}
	}

}
