package cn.com.duiba.service;

import cn.com.duiba.credits.sdk.CreditNotifyParams;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.CodeException;

import java.util.Map;

/**
 * 接口参数定制服务
 */
public interface CustomService {
	
	/**
	 * 是否是蘑菇街
	 * 
	 * @param appId
	 * @return
	 */
	public boolean isMogujie(Long appId);
	
	/**
	 * 是否是平安健康
	 * 
	 * @param appId
	 * @return
	 */
	public boolean isPajk(Long appId);

	/**
	 * 是否是淘金币
	 * @param appId
	 * @return
     */
	boolean isTaojinbi(Long appId);

	boolean isMobike(Long appId);

	/**
	 * 是否凤金积分商城
	 * @param appId
	 * @return
	 */
	boolean isFengJin(Long appId);

	/**
	 * 是否爱奇艺积分商城
	 * @param appId
	 * @return
	 */
	boolean isIqiyi(Long appId);

	/**
	 * 获取减积分请求参数
	 * 
	 * @param req
	 * @return
	 */
	public CreditsMessage getRequestCredits(CreditsMessage req);

	/**
	 * 获取积分响应结果
	 * 
	 * @param body
	 * @return
	 */
	public String getResponseCredits(String appId, String body );

	/**
	 * 获取通知请求参数
	 * 
	 * @param notifyUrl
     * @param record
	 * @return
	 */
	public String getRequestNotify(String notifyUrl, NotifyQueueDO record, String time, AppDO appDO);

	/**
	 * 获取通知响应结果
	 * 
	 * @param appId
	 * @param body
	 * @return
	 */
	public String getResponseNotify(Long appId, String body);
	
	/**
	 * 获取一个Long订单号
	 * @param duibaOrderNum
	 * @return
	 */
	public Long getLongOrderNum(String duibaOrderNum) throws CodeException;

	public boolean isNotifyWithTransfer(Long appId);

	Map<String, String> toRequestMapWithTransfer(String appSecret, CreditNotifyParams p, String transfer, String uid);

	/**
	 * 
	 * 功能描述:
	 * 获取加积分请求链接
	 *
	 * @return
	 */
	public CreditsMessageDto getRequestAddCredits(CreditsMessageDto req);

	public SupplierRequest getVirturalRequest(SupplierRequest request);
	
	public String  getVirturalResponse(SupplierRequest message,String body);
}
