package cn.com.duiba.biz.credits;

import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * 爱奇艺定制
 * Created by sunyan on 2017/8/25.
 */
@Service
public class IqiyiApi {
    private static Logger log = LoggerFactory.getLogger(IqiyiApi.class);

    private static final List<Long> iqiyiToutiaoIds=Arrays.asList(37066L,38347L);
    /**
     * 兑吧在爱奇艺的App的appkey
     */
    @Value("${iqiyi.app.appkey}")
    private String iqiyiAppkey;
    /**
     * 兑吧在爱奇艺的App的appsecret
     */
    @Value("${iqiyi.app.secret}")
    private String iqiyiAppSecret;

    /**
     * 构造爱奇艺扣积分请求.
     *
     * @param request
     * @return
     */
    public CreditsMessage getSubCreditsMessage(CreditsMessage request) {
        String url = request.getHttpUrl();
        String host = url.substring(0, url.indexOf('?'));
        String urlParams = url.substring(url.indexOf('?') + 1, url.length());
        // 1.将请求URL的参数转换为MAP
        Map<String, String> crediMap = AssembleTool.getUrlParams(urlParams);
        Map<String, String> authParams = getIqiyiAuthParams(Long.valueOf(request.getAppId()));

        authParams.put("userId", crediMap.get("uid"));
        authParams.put("orderNum", crediMap.get("orderNum"));
        authParams.put("score", crediMap.get("credits"));
        // 生成签名
        authParams.put("sign", sign(authParams,iqiyiAppSecret));

        request.setAuthParams(authParams);
        request.setHttpType(CreditsMessage.HTTP_POST);
        request.setHttpUrl(host);
        return request;
    }

    private Map<String, String> getIqiyiAuthParams(Long appId){
        Map<String, String> authParams = new HashMap<>();
        if(iqiyiToutiaoIds.contains(appId)){
            authParams.put("verticalCode", "Toutiao");
            authParams.put("typeCode", "Point");
            authParams.put("agenttype", "12");
            authParams.put("agentversion", "1.12.10");
            authParams.put("srcplatform", "12");
            authParams.put("appver", "1.12.10");
            authParams.put("itemSystem", "2");
        }else{
            authParams.put("verticalCode", "iQIYI");
            authParams.put("typeCode", "point");
            authParams.put("agenttype", "12");
            authParams.put("agentversion", "8.9.0");
            authParams.put("srcplatform", "12");
            authParams.put("appver", "8.9.0");
            authParams.put("itemSystem", "2");
        }
        authParams.put("appKey", iqiyiAppkey);
        authParams.put("secret_key", iqiyiAppSecret);
        return authParams;
    }
    /**
     * 爱奇艺积分商城, 获取通知请求参数
     * @param notifyUrl
     * @param record
     * @return
     */
    public String getRequestNotify(String notifyUrl, NotifyQueueDO record){
        Map<String, String> authParams = getIqiyiAuthParams(record.getAppId());
        authParams.put("userId",record.getPartnerUserId());
        authParams.put("orderNum",record.getDuibaOrderNum());
        authParams.put("transId",record.getDeveloperBizId());
        authParams.put("success",String.valueOf(record.getResult()));
        // 生成签名
        authParams.put("sign", sign(authParams,iqiyiAppSecret));
        return AssembleTool.assembleUrl(notifyUrl, authParams);
    }

    /**
     * @param params
     * @return
     */
    private String sign(Map<String, String> params, String secretKey) {
        SortedMap<String, String> sortedParams = new TreeMap<>(params);
        sortedParams.remove("sign");
        StringBuilder sb = new StringBuilder();
        for(Map.Entry<String, String> entry : sortedParams.entrySet()){
            String val = entry.getValue();
            sb.append(entry.getKey()).append("=").append(StringUtils.defaultIfEmpty(val, "")).append("|");
        }
        return DigestUtils.md5Hex(sb.append(secretKey).toString());
    }

    /**
     * 虚拟商品上游兑换Request
     * @param request
     * @return
     */
    public  SupplierRequest getVirtualRequest(SupplierRequest request){
        String url = request.getHttpUrl();
        String host = url.substring(0, url.indexOf('?'));
        String urlParams = url.substring(url.indexOf('?') + 1, url.length());
        // 1.将请求URL的参数转换为MAP
        Map<String, String> crediMap = AssembleTool.getUrlParams(urlParams);

        Map<String, String> authParams = getIqiyiAuthParams(Long.valueOf(request.getAppId()));
        authParams.remove("itemSystem");
        authParams.put("scoreType", "1");
        authParams.put("userId", crediMap.get("uid"));
        authParams.put("channelCode", crediMap.get("params"));
        // 生成签名
        authParams.put("sign", sign(authParams,iqiyiAppSecret));
        request.setHttpUrl(host);
        request.setAuthParams(authParams);
        return request;
    }

    /**
     * 虚拟商品上游兑换Respone
     * @param body
     * @return
     */
    public  String getVirtualRespone(String body) {
        JSONObject jsonBody;
        JSONObject jBody = new JSONObject();
        Map<String, String> duibaDoc = new HashMap<>();
        try {
            jsonBody = JSON.parseObject(body);
            JSONArray jList = jsonBody.getJSONArray("data");
            if(jList!=null&&!jList.isEmpty()){
                jBody = jList.getJSONObject(0);
            }
        } catch (Exception e) {
            log.error("返回body解析出错,VirtualRespone body="+body, e);
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", "返回body解析出错："+e.getMessage());
            return JsonTool.objectToJson(duibaDoc);
        }

        String code = jBody.getString("code");
        if ("A0000".equals(code)) {
            duibaDoc.put("status", "success");
            duibaDoc.put("credits", "-1");//积分不变（>=0才会更新）
        } else {
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", jBody.getString("message"));
        }
        return JsonTool.objectToJson(duibaDoc);
    }
}
