package cn.com.duiba.biz.credits;

import cn.com.duiba.order.center.api.dto.CreditsCallbackMessage;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.service.CustomService;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.service.MessageService;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.tool.JsonTool;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 扣积分服务类
 */
@Service
public class SubCreditsToDeveloper {

	private static final Logger LOG = LoggerFactory.getLogger(SubCreditsToDeveloper.class);

	@Autowired
	private MessageService messageService;

	@Autowired
	private HttpAsyncClientPool httpAsyncClientPool;

	@Autowired
	private CustomService customService;

	/**
	 * 提交扣积分HTTP请求
	 * @param req
	 * @param msgTopic
	 * @param msgTag
	 * @param msgKey
	 */
	public void submit(CreditsMessage req, final String msgTopic, final String msgTag, final String msgKey) {
		final CreditsMessage request = customService.getRequestCredits(req);
		HttpRequestBase http;
		if (CreditsMessage.HTTP_POST.equals(request.getHttpType())) {
			http = AssembleTool.assembleRequest(request.getHttpUrl(), request.getAuthParams());
			HttpRequestLog.logUrl("[action subCredits] [tag request] [bizId " + request.getRelationId() + "] [type " + request.getRelationType() + "] [post url " + request.getHttpUrl() + "][authParams "+request.getAuthParams()+"][consumerId " + request.getConsumerId() + "]" );
		} else {
			http = new HttpGet(request.getHttpUrl());
			HttpRequestLog.logUrl("[action subCredits] [tag request] [bizId " + request.getRelationId() + "] [type " + request.getRelationType() + "] [get url " + request.getHttpUrl() +"][consumerId " + request.getConsumerId() + "]");
		}
		if(customService.isMobike(Long.valueOf(request.getAppId()))){
			String time=request.getParams().get("time");
			if(StringUtils.isNotEmpty(time)){//摩拜需要在header中传递参数
				http.setHeader(new BasicHeader("time",time));
				http.setHeader(new BasicHeader("accesstoken",request.getParams().get("accesstoken")));
			}
		}
		httpAsyncClientPool.submit(request.getAppId(), http, new FutureCallback<HttpResponse>() {
			@Override
			public void completed(HttpResponse response) {
				CreditsCallbackMessage resp = new CreditsCallbackMessage();
				try {
					resp.setCallbackType(CreditsCallbackMessage.CALLBACK_TYPE_COMPLETED);
					String body = customService.getResponseCredits(request.getAppId(), EntityUtils.toString(response.getEntity()));
					resp.setMessage(HttpRequestLog.subBody(body));
				} catch (Exception e) {
					LOG.error("toDeveloper completed", e);
				} finally {
					finallyBlock(request, resp, msgTopic, msgTag, msgKey, Integer.toString(response.getStatusLine().getStatusCode()));
				}
			}

			@Override
			public void failed(Exception ex) {
				LOG.error("toDeveloper failed bizId:" + request.getRelationId() + " bizType:" + request.getRelationType(), ex);
				CreditsCallbackMessage resp = new CreditsCallbackMessage();
				try {
					resp.setCallbackType(CreditsCallbackMessage.CALLBACK_TYPE_FAILED);
					resp.setMessage(ex.getClass().getName() + ":" + ex.getMessage());
				} catch (Exception e) {
					LOG.error("toDeveloper failed", e);
				} finally {
					finallyBlock(request, resp, msgTopic, msgTag, msgKey, "");
				}
			}

			@Override
			public void cancelled() {
				LOG.info("toDeveloper cancelled bizId:" + request.getRelationId() + " bizType:" + request.getRelationType());
				CreditsCallbackMessage resp = new CreditsCallbackMessage();
				try {
					resp.setCallbackType(CreditsCallbackMessage.CALLBACK_TYPE_FAILED);
					resp.setMessage("http cancelled");
				} catch (Exception e) {
					LOG.error("toDeveloper cancelled", e);
				} finally {
					finallyBlock(request, resp, msgTopic, msgTag, msgKey, "");
				}
			}

		});
	}

	/**
	 * 返回响应结果到业务放
	 * @param req
	 * @param resp
	 * @param msgTopic
	 * @param msgTag
	 * @param msgKey
	 */
	private void finallyBlock(CreditsMessage req, CreditsCallbackMessage resp, String msgTopic, String msgTag, String msgKey, String code) {
		try {
			resp.setRelationId(req.getRelationId());
			resp.setRelationType(req.getRelationType());
			resp.setParams(req.getParams());
			resp.setAppId(req.getAppId());
			resp.setConsumerId(req.getConsumerId());
			resp.setHttpUrl(req.getHttpUrl());
			String body = JsonTool.objectToJson(resp);
			if(StringUtils.isEmpty(msgTag) && StringUtils.isEmpty(msgKey)){
				messageService.sendMsg(msgTopic, body);
			}else{
				messageService.sendMsg(msgTopic, msgTag, msgKey, body);
			}
		} catch (Exception e) {
			LOG.error("credits callback: bizId:" + req.getRelationId() + " bizType:" + req.getRelationType(), e);
		} finally {
			HttpRequestLog.logUrl("[action subCredits] [tag response] [code "+code+"] [bizId " + req.getRelationId() + "] [type " + req.getRelationType() + "] [callback " + resp.getCallbackType() + "] [body " + resp.getMessage() + "]");
		}
	}

}