package cn.com.duiba.notifycenter.dao.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.dao.BaseDAO;
import cn.com.duiba.notifycenter.dao.NotifyQueueDAO;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;

/**
 * 通知DAO
 */
@Repository("notifyQueueDAO")
public class NotifyQueueDAOImpl extends BaseDAO implements NotifyQueueDAO {

	@Override
	public List<NotifyQueueDO> findNeedNotifyList() {
		return getSqlSession().selectList(getStamentNameSpace("findNeedNotifyList"));
	}

	@Override
	public NotifyQueueDO find(Long id) {
		return getSqlSession().selectOne(getStamentNameSpace("find"), id);
	}

	@Override
	public void finish(Long id) {
		getSqlSession().delete(getStamentNameSpace("finish"), id);
	}

	@Override
	public int updateNextTime(Long id, int times, Date nextTime) {
		Map<String, Object> params = new HashMap<>();
		params.put("id", id);
		params.put("times", times);
		params.put("nextTime", nextTime);
		return getSqlSession().update(getStamentNameSpace("updateNextTime"), params);
	}

	@Override
	public void insert(NotifyQueueDO notifyQueueDO) {
		getSqlSession().insert(getStamentNameSpace("insert"), notifyQueueDO);
	}
}
