package cn.com.duiba.remoteimpl;

import cn.com.duiba.biz.alipay.domain.AlipayOfficialRequest;
import cn.com.duiba.biz.alipay.supplier.AlipayBatchExecutor;
import cn.com.duiba.biz.alipay.supplier.ZhongXiangSupplier;
import cn.com.duiba.biz.phonebill.supplier.GyjxPhonebillSupplier;
import cn.com.duiba.biz.phonebill.supplier.LianLianPhonebillSupplier;
import cn.com.duiba.biz.phonebill.supplier.NewLianLianPhonebillSupplier;
import cn.com.duiba.biz.phonebill.supplier.OufeiPhonebillSupplier;
import cn.com.duiba.biz.phonebill.supplier.SududaPhonebillSupplier;
import cn.com.duiba.biz.phoneflow.supplier.MoPinPhoneflowSupplier;
import cn.com.duiba.biz.qb.supplier.EnlianQBSupplier;
import cn.com.duiba.biz.qb.supplier.GoukaQBSupplier;
import cn.com.duiba.biz.qb.supplier.TencentQBSupplier;
import cn.com.duiba.biz.virtual.supplier.VirtualSupplier;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.order.center.api.dto.SupplierProductDto;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.thirdparty.api.RemoteChargeService;
import cn.com.duiba.thirdparty.dto.AlipayOfficialRequestDto;
import cn.com.duiba.thirdparty.dto.SupplierRequestDto;
import cn.com.duiba.tool.CodeException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

/**
 * 直冲类接口请求远程服务实现类
 */
@RestController
public class RemoteChargeServiceImpl implements RemoteChargeService {

	private static final Logger LOGGER = LoggerFactory.getLogger(RemoteChargeServiceImpl.class);

	@Autowired
	private AlipayBatchExecutor alipayBatchExecutor;
	@Autowired
	private ZhongXiangSupplier zhongXiangSupplier;
	@Autowired
	private EnlianQBSupplier enlianQBSupplier;
	@Autowired
	private GoukaQBSupplier goukaQBSupplier;
	@Autowired
	private TencentQBSupplier tencentQBSupplier;
	@Autowired
	private GyjxPhonebillSupplier gyjxPhonebillSupplier;
	@Autowired
	private OufeiPhonebillSupplier oufeiPhonebillSupplier;
	@Autowired
	private SududaPhonebillSupplier sududaPhonebillSupplier;
	@Autowired
	private LianLianPhonebillSupplier lianLianPhonebillSupplier;
	@Autowired
	private NewLianLianPhonebillSupplier newLianLianPhonebillSupplier;
	@Autowired
	private MoPinPhoneflowSupplier moPinPhoneflowSupplier;
	@Autowired
	private VirtualSupplier virtualSupplier;
	@Autowired
	private HttpAsyncClientPool httpAsyncClientPool;

	/**
	 * 提交官方支付宝请求
	 */
	@Override
	public DubboResult<Boolean> submitAlipay(AlipayOfficialRequestDto request) {
		try {
			AlipayOfficialRequest req = BeanUtils.copy(request, AlipayOfficialRequest.class);
			alipayBatchExecutor.addAlipayOrder(req);
			return DubboResult.successResult(true);
		} catch (Exception e) {
			LOGGER.error("submitAlipay", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	/**
	 * 提交众想支付宝接口请求
	 */
	@Override
	public DubboResult<Boolean> submitZxAlipay(SupplierRequestDto supplierRequestDto, String callbackTopic) {
		try {
			SupplierRequest sr = BeanUtils.copy(supplierRequestDto, SupplierRequest.class);
			validate(sr, callbackTopic);
			zhongXiangSupplier.asyncSubmit(sr, callbackTopic, null, null);
			return DubboResult.successResult(true);
		} catch (Exception e) {
			LOGGER.error("submitZxAlipay", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	/**
	 * 提交QB接口请求
	 */
	@Override
	public DubboResult<Boolean> submitQb(SupplierRequestDto request, String callbackTopic) {
		return submitQb(request, callbackTopic, null, null);
	}

	/**
	 * 提交话费接口请求
	 */
	@Override
	public DubboResult<Boolean> submitPhonebill(SupplierRequestDto supplierRequestDto, String callbackTopic) {
		return submitPhonebill(supplierRequestDto, callbackTopic, null, null);
	}

	/**
	 * 提交流量接口请求
	 */
	@Override
	public DubboResult<Boolean> submitPhoneflow(SupplierRequestDto supplierRequestDto, String callbackTopic) {
		return submitPhoneflow(supplierRequestDto, callbackTopic, null, null);
	}

	/**
	 * 提交虚拟商品接口请求
	 */
	@Override
	public DubboResult<Boolean> submitVirtual(SupplierRequestDto supplierRequestDto, String callbackTopic) {
		return submitVirtual(supplierRequestDto, callbackTopic, null, null);
	}

	private void validate(SupplierRequest request, String callbackTopic) throws CodeException {
		if (request == null) {
			throw new CodeException("0", "参数校验失败");
		}
		if (StringUtils.isEmpty(callbackTopic)) {
			throw new CodeException("0", "订阅Topic不能为空");
		}
	}

	private void validateVirtual(SupplierRequest request, String callbackTopic) throws CodeException {
		if (StringUtils.isEmpty(callbackTopic)) {
			throw new CodeException("0", "订阅Topic不能为空");
		}
		if (StringUtils.isEmpty(request.getHttpUrl())) {
			throw new CodeException("0", "请求URL不能为空");
		}
		if (request.getAppId() == null) {
			throw new CodeException("0", "APPID不能为空");
		}
		if (!httpAsyncClientPool.canSubmitToAppPool(request.getAppId())) {
			throw new CodeException("0", "APP队列超过阀值，APP接口繁忙");
		}
	}

	@Override
	public DubboResult<Boolean> submitZxAlipay(SupplierRequestDto supplierRequestDto, String callbackTopic, String msgTag, String msgKey) {
		try {
			SupplierRequest sr = BeanUtils.copy(supplierRequestDto, SupplierRequest.class);
			validate(sr, callbackTopic);
			zhongXiangSupplier.asyncSubmit(sr, callbackTopic, msgTag, msgKey);
			return DubboResult.successResult(true);
		} catch (Exception e) {
			LOGGER.error("submitZxAlipay", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Boolean> submitQb(SupplierRequestDto request, String callbackTopic, String msgTag, String msgKey) {
		try {
			SupplierRequest req = BeanUtils.copy(request, SupplierRequest.class);
			validate(req, callbackTopic);
			if (SupplierProductDto.SupplierQBTencent.equals(request.getSupplierName())) {
				tencentQBSupplier.asyncSubmit(req, callbackTopic, msgTag, msgKey);
			} else if (SupplierProductDto.SupplierQBEnlian.equals(request.getSupplierName())) {
				enlianQBSupplier.asyncSubmit(req, callbackTopic, msgTag, msgKey);
			} else if (SupplierProductDto.SupplierQBGouka.equals(request.getSupplierName())) {
				goukaQBSupplier.asyncSubmit(req, callbackTopic, msgTag, msgKey);
			} else {
				throw new CodeException("0", "QB无对应上游：" + request.getSupplierName());
			}
			return DubboResult.successResult(true);
		} catch (Exception e) {
			LOGGER.error("submitQb", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Boolean> submitPhonebill(SupplierRequestDto supplierRequestDto, String callbackTopic, String msgTag, String msgKey) {
		try {
			SupplierRequest request = BeanUtils.copy(supplierRequestDto, SupplierRequest.class);
			validate(request, callbackTopic);
			if (cn.com.duiba.order.center.api.dto.SupplierProductDto.SupplierPhonebillGyjx.equals(request.getSupplierName())) {
				gyjxPhonebillSupplier.asyncSubmit(request, callbackTopic, msgTag, msgKey);
			} else if (SupplierProductDto.SupplierPhonebillOufei.equals(request.getSupplierName())) {
				oufeiPhonebillSupplier.asyncSubmit(request, callbackTopic, msgTag, msgKey);
			} else if (SupplierProductDto.SupplierPhonebillNewLianlian.equals(request.getSupplierName())) {
				newLianLianPhonebillSupplier.asyncSubmit(request, callbackTopic, msgTag, msgKey);
			} else if (SupplierProductDto.SupplierPhonebillLianlian.equals(request.getSupplierName())) {
				lianLianPhonebillSupplier.asyncSubmit(request, callbackTopic, msgTag, msgKey);
			} else if (SupplierProductDto.SupplierPhonebillSududa.equals(request.getSupplierName())) {
				sududaPhonebillSupplier.asyncSubmit(request, callbackTopic, msgTag, msgKey);
			} else {
				throw new CodeException("0", "phonebill无对应上游：" + request.getSupplierName());
			}
			return DubboResult.successResult(true);
		} catch (Exception e) {
			LOGGER.error("submitPhonebill", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Boolean> submitPhoneflow(SupplierRequestDto supplierRequestDto, String callbackTopic, String msgTag, String msgKey) {
		try {
			SupplierRequest request = BeanUtils.copy(supplierRequestDto, SupplierRequest.class);
			validate(request, callbackTopic);
			moPinPhoneflowSupplier.asyncSubmit(request, callbackTopic, msgTag, msgKey);
			return DubboResult.successResult(true);
		} catch (Exception e) {
			LOGGER.error("submitPhoneflow", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Boolean> submitVirtual(SupplierRequestDto supplierRequestDto, String callbackTopic, String tag, String key) {
		try {
			SupplierRequest request = BeanUtils.copy(supplierRequestDto, SupplierRequest.class);
			validateVirtual(request, callbackTopic);
			virtualSupplier.asyncSubmit(request, callbackTopic, tag, key);	
			return DubboResult.successResult(true);
		} catch (Exception e) {
			LOGGER.error("submitVirtual", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

}
