package cn.com.duiba.remoteimpl;

import cn.com.duiba.biz.credits.AddCreditsToDeveloper;
import cn.com.duiba.biz.credits.SubCreditsToDeveloper;
import cn.com.duiba.domain.HttpMessageDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.thirdparty.api.RemoteCreditsService;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;
import cn.com.duiba.tool.CodeException;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

/**
 * 扣/加积分 远程服务实现类
 */
@RestController
public class RemoteCreditsServiceImpl implements RemoteCreditsService {

	private static final Logger LOG = LoggerFactory.getLogger(RemoteCreditsServiceImpl.class);

	@Autowired
	private SubCreditsToDeveloper subCreditsToDeveloper;

	@Autowired
	private AddCreditsToDeveloper addCreditsToDeveloper;

	@Autowired
	private HttpAsyncClientPool httpAsyncClientPool;

	private String defaultQueue = "0";

	/**
	 * 验证提交请求
	 * 
	 * @param request
	 * @param callbackTopic
	 * @throws CodeException
	 */
	private void validate(CreditsMessage request, String callbackTopic) throws CodeException {
		if (StringUtils.isEmpty(callbackTopic)) {
			throw new CodeException("0", "订阅Topic不能为空");
		}
		if (StringUtils.isEmpty(request.getHttpUrl())) {
			throw new CodeException("0", "请求URL不能为空");
		}
		if (request.getAppId() == null) {
			throw new CodeException("0", "APPID不能为空");
		}
		if (!httpAsyncClientPool.canSubmitToAppPool(request.getAppId())) {
			throw new CodeException("0", "开发者接口繁忙");
		}
	}

	/**
	 * @deprecated
	 */
	@Deprecated
	@Override
	public DubboResult<Boolean> submitSubCredits(CreditsMessage request, String callbackTopic) {
		try {
			validate(request, callbackTopic);
			subCreditsToDeveloper.submit(request, callbackTopic, null, null);
			return DubboResult.successResult(true);
		} catch (CodeException e) {
			LOG.error("submitSubCredits", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	/**
	 * @deprecated
	 */
	@Deprecated
	@Override
	public DubboResult<Boolean> submitAddCredits(CreditsMessage request, String callbackTopic) {
		try {
			validate(request, callbackTopic);
			CreditsMessageDto dto = BeanUtils.copy(request, CreditsMessageDto.class);
			dto.setCallbackTopic(callbackTopic);
			HttpMessageDO message = new HttpMessageDO();
			message.setAppId(Long.valueOf(request.getAppId()));
			message.setBizType(HttpRequestMessageDto.RETRY_ADD_CREDITS);
			message.setBizParams(JsonTool.objectToJson(dto));
			message.setNumber(0);
			addCreditsToDeveloper.submit(message);
			return DubboResult.successResult(true);
		} catch (CodeException e) {
			LOG.error("submitAddCredits", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Boolean> submitSubCredits(CreditsMessage request, String callbackTopic, String tag, String key) {
		try {
			validate(request, callbackTopic);
			subCreditsToDeveloper.submit(request, callbackTopic, tag, key);
			return DubboResult.successResult(true);
		} catch (CodeException e) {
			LOG.error("submitSubCredits", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Boolean> submitAddCredits(CreditsMessage request, String callbackTopic, String tag, String key) {
		try {
			validate(request, callbackTopic);
			CreditsMessageDto dto = BeanUtils.copy(request, CreditsMessageDto.class);
			dto.setCallbackTopic(callbackTopic);
			dto.setCallbackTag(tag);
			dto.setCallbackKey(key);
			HttpMessageDO message = new HttpMessageDO();
			String appId = request.getAppId() == null ? defaultQueue : request.getAppId();
			message.setAppId(Long.valueOf(appId));
			message.setBizType(HttpRequestMessageDto.RETRY_ADD_CREDITS);
			message.setBizParams(JsonTool.objectToJson(dto));
			message.setNumber(0);
			addCreditsToDeveloper.submit(message);
			return DubboResult.successResult(true);
		} catch (CodeException e) {
			LOG.error("submitAddCredits", e);
			return DubboResult.failResult(e.getMessage());
		}
	}
}
