package cn.com.duiba.service;

import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.protocol.HttpContext;

/**
 * Created by zzy on 2017/11/20.
 */
public class HttpClientFactory {

    /**
     * 连接超时
     */
    public static final int CONNECT_TIMEOUT = 30 * 1000;

    /**
     * 长链接空闲时间
     */
    public static final int KEEPALIVE_TIMEOUT = 30 * 1000;

    /**
     * 处理超时
     */
    public static final int SOCKET_TIMEOUT = 30 * 1000;

    /**
     * 最大总连接值
     */
    public static final int MAX_CONNECT = 5000;

    /**
     * 每个路由最大连接{并发}值
     */
    public static final int MAX_ROUTE_CONNECT = 300;

    public static CloseableHttpAsyncClient newCloseableHttpAsyncClient() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(CONNECT_TIMEOUT).setConnectionRequestTimeout(CONNECT_TIMEOUT).setSocketTimeout(SOCKET_TIMEOUT).build();
        CloseableHttpAsyncClient httpClient = HttpAsyncClients.custom().setDefaultRequestConfig(config).setMaxConnTotal(MAX_CONNECT).setMaxConnPerRoute(MAX_ROUTE_CONNECT).setKeepAliveStrategy(getKeepAliveStrategy()).build();
        httpClient.start();
        return httpClient;
    }

    /**
     * 长连接
     *
     * @return
     */
    private static DefaultConnectionKeepAliveStrategy getKeepAliveStrategy() {
        return new DefaultConnectionKeepAliveStrategy() {
            @Override
            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                long duration = super.getKeepAliveDuration(response, context);
                if (duration == -1) {
                    return KEEPALIVE_TIMEOUT;
                }
                return duration;
            }
        };
    }
}