package cn.com.duiba.service;


import cn.com.duiba.notifycenter.service.NotifyHttpClientPool;

/**
 * Created by zzy on 2017/11/20.
 */
public interface SlowRequestHandler {
    /**
     * 是否是慢请求host
     *
     * @param url
     * @return
     */
    boolean isSlow(String url);


    /**
     * 标记慢请求
     *
     * @param url   请求url
     * @param delay 延迟的时间(s)
     */
    void addSlow(String url, int delay);

    /**
     * 添加到异步队列中
     *
     * @param callbackProcesser
     * @return
     */
    boolean addQueue(NotifyHttpClientPool.CallbackProcesser callbackProcesser);

    /**
     * 添加到异步队列中
     *
     * @param callbackProcesser
     * @return
     */
    boolean addQueue(HttpAsyncClientPool.CallbackProcesser callbackProcesser);
}